/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class PKCS5S2ParametersGenerator
extends PBEParametersGenerator {
    private Mac hMac;

    public PKCS5S2ParametersGenerator() {
        this(new SHA1Digest());
    }

    public PKCS5S2ParametersGenerator(Digest digest) {
        this.hMac = new HMac(digest);
    }

    private void F(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4, int n3) {
        byte[] byArray5 = new byte[this.hMac.getMacSize()];
        KeyParameter keyParameter = new KeyParameter(byArray);
        this.hMac.init(keyParameter);
        if (byArray2 != null) {
            this.hMac.update(byArray2, 0, byArray2.length);
        }
        this.hMac.update(byArray3, 0, byArray3.length);
        this.hMac.doFinal(byArray5, 0);
        System.arraycopy(byArray5, 0, byArray4, n3, byArray5.length);
        if (n2 == 0) {
            throw new IllegalArgumentException("iteration count must be at least 1.");
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            this.hMac.init(keyParameter);
            this.hMac.update(byArray5, 0, byArray5.length);
            this.hMac.doFinal(byArray5, 0);
            for (int i3 = 0; i3 != byArray5.length; ++i3) {
                int n4 = n3 + i3;
                byArray4[n4] = (byte)(byArray4[n4] ^ byArray5[i3]);
            }
        }
    }

    private void intToOctet(byte[] byArray, int n2) {
        byArray[0] = (byte)(n2 >>> 24);
        byArray[1] = (byte)(n2 >>> 16);
        byArray[2] = (byte)(n2 >>> 8);
        byArray[3] = (byte)n2;
    }

    private byte[] generateDerivedKey(int n2) {
        int n3 = this.hMac.getMacSize();
        int n4 = (n2 + n3 - 1) / n3;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[n4 * n3];
        for (int i2 = 1; i2 <= n4; ++i2) {
            this.intToOctet(byArray, i2);
            this.F(this.password, this.salt, this.iterationCount, byArray, byArray2, (i2 - 1) * n3);
        }
        return byArray2;
    }

    public CipherParameters generateDerivedParameters(int n2) {
        byte[] byArray = this.generateDerivedKey(n2 /= 8);
        return new KeyParameter(byArray, 0, n2);
    }

    public CipherParameters generateDerivedParameters(int n2, int n3) {
        byte[] byArray = this.generateDerivedKey((n2 /= 8) + (n3 /= 8));
        return new ParametersWithIV(new KeyParameter(byArray, 0, n2), byArray, n2, n3);
    }

    public CipherParameters generateDerivedMacParameters(int n2) {
        return this.generateDerivedParameters(n2);
    }
}

