/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.backend;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.server.ServerInfo;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.config.PlayerInfoForwarding;
import com.velocitypowered.proxy.connection.ConnectionTypes;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftConnectionAssociation;
import com.velocitypowered.proxy.connection.backend.BackendConnectionPhase;
import com.velocitypowered.proxy.connection.backend.BackendConnectionPhases;
import com.velocitypowered.proxy.connection.backend.LoginSessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.registry.DimensionRegistry;
import com.velocitypowered.proxy.connection.util.ConnectionRequestResults;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.Handshake;
import com.velocitypowered.proxy.protocol.packet.PluginMessage;
import com.velocitypowered.proxy.protocol.packet.ServerLogin;
import com.velocitypowered.proxy.server.VelocityRegisteredServer;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VelocityServerConnection
implements MinecraftConnectionAssociation,
ServerConnection {
    private final VelocityRegisteredServer registeredServer;
    private final ConnectedPlayer proxyPlayer;
    private final VelocityServer server;
    private @Nullable MinecraftConnection connection;
    private boolean hasCompletedJoin = false;
    private boolean gracefulDisconnect = false;
    private BackendConnectionPhase connectionPhase = BackendConnectionPhases.UNKNOWN;
    private final Map<Long, Long> pendingPings = new HashMap<Long, Long>();
    private @MonotonicNonNull DimensionRegistry activeDimensionRegistry;

    public VelocityServerConnection(VelocityRegisteredServer registeredServer, ConnectedPlayer proxyPlayer, VelocityServer server) {
        this.registeredServer = registeredServer;
        this.proxyPlayer = proxyPlayer;
        this.server = server;
    }

    public CompletableFuture<ConnectionRequestResults.Impl> connect() {
        CompletableFuture<ConnectionRequestResults.Impl> result = new CompletableFuture<ConnectionRequestResults.Impl>();
        ((Bootstrap)this.server.createBootstrap(this.proxyPlayer.getConnection().eventLoop()).handler(this.server.getBackendChannelInitializer())).connect(this.registeredServer.getServerInfo().getAddress()).addListener(future -> {
            if (future.isSuccess()) {
                this.connection = new MinecraftConnection(future.channel(), this.server);
                this.connection.setAssociation(this);
                future.channel().pipeline().addLast("handler", (ChannelHandler)this.connection);
                this.connection.setSessionHandler(new LoginSessionHandler(this.server, this, result));
                this.connectionPhase = this.connection.getType().getInitialBackendPhase();
                this.startHandshake();
            } else {
                result.completeExceptionally(future.cause());
            }
        });
        return result;
    }

    private String createLegacyForwardingAddress(UnaryOperator<List<GameProfile.Property>> propertiesTransform) {
        StringBuilder data = new StringBuilder().append(this.proxyPlayer.getVirtualHost().orElseGet(() -> this.registeredServer.getServerInfo().getAddress()).getHostString()).append('\u0000').append(this.proxyPlayer.getRemoteAddress().getHostString()).append('\u0000').append(this.proxyPlayer.getGameProfile().getUndashedId()).append('\u0000');
        VelocityServer.GENERAL_GSON.toJson(propertiesTransform.apply(this.proxyPlayer.getGameProfile().getProperties()), (Appendable)data);
        return data.toString();
    }

    private String createLegacyForwardingAddress() {
        return this.createLegacyForwardingAddress(UnaryOperator.identity());
    }

    private String createBungeeGuardForwardingAddress(byte[] forwardingSecret) {
        GameProfile.Property property = new GameProfile.Property("bungeeguard-token", new String(forwardingSecret, StandardCharsets.UTF_8), "");
        return this.createLegacyForwardingAddress(properties -> ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)properties)).add(property)).build());
    }

    private void startHandshake() {
        MinecraftConnection mc = this.ensureConnected();
        PlayerInfoForwarding forwardingMode = this.server.getConfiguration().getPlayerInfoForwardingMode();
        InetSocketAddress destAddress = this.registeredServer.getServerInfo().getAddress();
        ProtocolVersion protocolVersion = this.proxyPlayer.getConnection().getProtocolVersion();
        Handshake handshake = new Handshake();
        handshake.setNextStatus(2);
        handshake.setProtocolVersion(protocolVersion);
        if (forwardingMode == PlayerInfoForwarding.LEGACY) {
            handshake.setServerAddress(this.createLegacyForwardingAddress());
        } else if (forwardingMode == PlayerInfoForwarding.BUNGEEGUARD) {
            byte[] secret = this.server.getConfiguration().getForwardingSecret();
            handshake.setServerAddress(this.createBungeeGuardForwardingAddress(secret));
        } else if (this.proxyPlayer.getConnection().getType() == ConnectionTypes.LEGACY_FORGE) {
            handshake.setServerAddress(destAddress.getHostString() + "\u0000FML\u0000");
        } else {
            handshake.setServerAddress(destAddress.getHostString());
        }
        handshake.setPort(destAddress.getPort());
        mc.delayedWrite(handshake);
        mc.setProtocolVersion(protocolVersion);
        mc.setState(StateRegistry.LOGIN);
        mc.delayedWrite(new ServerLogin(this.proxyPlayer.getUsername()));
        mc.flush();
    }

    public @Nullable MinecraftConnection getConnection() {
        return this.connection;
    }

    public MinecraftConnection ensureConnected() {
        if (this.connection == null) {
            throw new IllegalStateException("Not connected to server!");
        }
        return this.connection;
    }

    @Override
    public VelocityRegisteredServer getServer() {
        return this.registeredServer;
    }

    @Override
    public ServerInfo getServerInfo() {
        return this.registeredServer.getServerInfo();
    }

    @Override
    public ConnectedPlayer getPlayer() {
        return this.proxyPlayer;
    }

    public void disconnect() {
        if (this.connection != null) {
            this.gracefulDisconnect = true;
            this.connection.close(false);
            this.connection = null;
        }
    }

    public String toString() {
        return "[server connection] " + this.proxyPlayer.getGameProfile().getName() + " -> " + this.registeredServer.getServerInfo().getName();
    }

    @Override
    public boolean sendPluginMessage(ChannelIdentifier identifier, byte[] data) {
        return this.sendPluginMessage(identifier, Unpooled.wrappedBuffer(data));
    }

    public boolean sendPluginMessage(ChannelIdentifier identifier, ByteBuf data) {
        Preconditions.checkNotNull(identifier, "identifier");
        Preconditions.checkNotNull(data, "data");
        MinecraftConnection mc = this.ensureConnected();
        PluginMessage message = new PluginMessage(identifier.getId(), data);
        mc.write(message);
        return true;
    }

    public void completeJoin() {
        if (!this.hasCompletedJoin) {
            this.hasCompletedJoin = true;
            if (this.connectionPhase == BackendConnectionPhases.UNKNOWN) {
                this.connectionPhase = BackendConnectionPhases.VANILLA;
                if (this.connection != null) {
                    this.connection.setType(ConnectionTypes.VANILLA);
                }
            }
        }
    }

    boolean isGracefulDisconnect() {
        return this.gracefulDisconnect;
    }

    public Map<Long, Long> getPendingPings() {
        return this.pendingPings;
    }

    public boolean isActive() {
        return this.connection != null && !this.connection.isClosed() && !this.gracefulDisconnect && this.proxyPlayer.isActive();
    }

    public BackendConnectionPhase getPhase() {
        return this.connectionPhase;
    }

    public void setConnectionPhase(BackendConnectionPhase connectionPhase) {
        this.connectionPhase = connectionPhase;
    }

    public boolean hasCompletedJoin() {
        return this.hasCompletedJoin;
    }

    public DimensionRegistry getActiveDimensionRegistry() {
        return this.activeDimensionRegistry;
    }

    public void setActiveDimensionRegistry(DimensionRegistry activeDimensionRegistry) {
        this.activeDimensionRegistry = activeDimensionRegistry;
    }
}

