/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.util;

import java.io.IOException;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.TagStringIO;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.util.Codec;
import org.checkerframework.checker.nullness.qual.NonNull;

public class VelocityLegacyHoverEventSerializer
implements LegacyHoverEventSerializer {
    public static final LegacyHoverEventSerializer INSTANCE = new VelocityLegacyHoverEventSerializer();

    private VelocityLegacyHoverEventSerializer() {
    }

    private static Key legacyIdToFakeKey(byte id) {
        return Key.key("velocity", "legacy_hover/id_" + id);
    }

    @Override
    public  @NonNull HoverEvent.ShowItem deserializeShowItem(@NonNull Component input) throws IOException {
        String snbt = PlainComponentSerializer.plain().serialize(input);
        CompoundBinaryTag item = TagStringIO.get().asCompound(snbt);
        String idIfString = item.getString("id", "");
        Key key = idIfString.isEmpty() ? VelocityLegacyHoverEventSerializer.legacyIdToFakeKey(item.getByte("id")) : Key.key(idIfString);
        byte count = item.getByte("Count", (byte)1);
        return HoverEvent.ShowItem.of(key, (int)count, BinaryTagHolder.of(snbt));
    }

    @Override
    public  @NonNull HoverEvent.ShowEntity deserializeShowEntity(@NonNull Component input, Codec.Decoder<Component, String, ? extends RuntimeException> componentDecoder) throws IOException {
        Component name;
        String snbt = PlainComponentSerializer.plain().serialize(input);
        CompoundBinaryTag item = TagStringIO.get().asCompound(snbt);
        try {
            name = componentDecoder.decode(item.getString("name"));
        }
        catch (Exception e) {
            name = Component.text(item.getString("name"));
        }
        return HoverEvent.ShowEntity.of(Key.key(item.getString("type")), UUID.fromString(item.getString("id")), name);
    }

    @Override
    public @NonNull Component serializeShowItem( @NonNull HoverEvent.ShowItem input) throws IOException {
        CompoundBinaryTag.Builder builder = (CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putByte("Count", (byte)input.count());
        String keyAsString = input.item().asString();
        if (keyAsString.startsWith("velocity:legacy_hover/id_")) {
            builder.putByte("id", Byte.parseByte(keyAsString.substring("velocity:legacy_hover/id_".length())));
        } else {
            builder.putString("id", keyAsString);
        }
        BinaryTagHolder nbt = input.nbt();
        if (nbt != null) {
            builder.put("tag", TagStringIO.get().asCompound(nbt.string()));
        }
        return Component.text(TagStringIO.get().asString(builder.build()));
    }

    @Override
    public @NonNull Component serializeShowEntity( @NonNull HoverEvent.ShowEntity input, Codec.Encoder<Component, String, ? extends RuntimeException> componentEncoder) throws IOException {
        CompoundBinaryTag.Builder tag = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("id", input.id().toString())).putString("type", input.type().asString());
        Component name = input.name();
        if (name != null) {
            tag.putString("name", componentEncoder.encode(name));
        }
        return Component.text(TagStringIO.get().asString(tag.build()));
    }
}

