/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.backend;

import com.velocitypowered.api.event.player.ServerLoginPluginMessageEvent;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.config.PlayerInfoForwarding;
import com.velocitypowered.proxy.config.VelocityConfiguration;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.TransitionSessionHandler;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.util.ConnectionRequestResults;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.Disconnect;
import com.velocitypowered.proxy.protocol.packet.EncryptionRequest;
import com.velocitypowered.proxy.protocol.packet.LoginPluginMessage;
import com.velocitypowered.proxy.protocol.packet.LoginPluginResponse;
import com.velocitypowered.proxy.protocol.packet.ServerLoginSuccess;
import com.velocitypowered.proxy.protocol.packet.SetCompression;
import com.velocitypowered.proxy.util.except.QuietRuntimeException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.kyori.adventure.text.Component;

public class LoginSessionHandler
implements MinecraftSessionHandler {
    private static final Component MODERN_IP_FORWARDING_FAILURE = Component.translatable("velocity.error.modern-forwarding-failed");
    private final VelocityServer server;
    private final VelocityServerConnection serverConn;
    private final CompletableFuture<ConnectionRequestResults.Impl> resultFuture;
    private boolean informationForwarded;

    LoginSessionHandler(VelocityServer server, VelocityServerConnection serverConn, CompletableFuture<ConnectionRequestResults.Impl> resultFuture) {
        this.server = server;
        this.serverConn = serverConn;
        this.resultFuture = resultFuture;
    }

    @Override
    public boolean handle(EncryptionRequest packet) {
        throw new IllegalStateException("Backend server is online-mode!");
    }

    @Override
    public boolean handle(LoginPluginMessage packet) {
        MinecraftConnection mc = this.serverConn.ensureConnected();
        VelocityConfiguration configuration = this.server.getConfiguration();
        if (configuration.getPlayerInfoForwardingMode() == PlayerInfoForwarding.MODERN && packet.getChannel().equals("velocity:player_info")) {
            ByteBuf forwardingData = LoginSessionHandler.createForwardingData(configuration.getForwardingSecret(), this.serverConn.getPlayerRemoteAddressAsString(), this.serverConn.getPlayer().getGameProfile());
            LoginPluginResponse response = new LoginPluginResponse(packet.getId(), true, forwardingData);
            mc.write(response);
            this.informationForwarded = true;
        } else {
            if (!this.server.getEventManager().hasSubscribers(ServerLoginPluginMessageEvent.class)) {
                mc.write(new LoginPluginResponse(packet.getId(), false, Unpooled.EMPTY_BUFFER));
                return true;
            }
            byte[] contents = ByteBufUtil.getBytes(packet.content());
            MinecraftChannelIdentifier identifier = MinecraftChannelIdentifier.from(packet.getChannel());
            this.server.getEventManager().fire(new ServerLoginPluginMessageEvent(this.serverConn, identifier, contents, packet.getId())).thenAcceptAsync(event -> {
                if (event.getResult().isAllowed()) {
                    mc.write(new LoginPluginResponse(packet.getId(), true, Unpooled.wrappedBuffer(event.getResult().getResponse())));
                } else {
                    mc.write(new LoginPluginResponse(packet.getId(), false, Unpooled.EMPTY_BUFFER));
                }
            }, (Executor)mc.eventLoop());
        }
        return true;
    }

    @Override
    public boolean handle(Disconnect packet) {
        this.resultFuture.complete(ConnectionRequestResults.forDisconnect(packet, (RegisteredServer)this.serverConn.getServer()));
        this.serverConn.disconnect();
        return true;
    }

    @Override
    public boolean handle(SetCompression packet) {
        this.serverConn.ensureConnected().setCompressionThreshold(packet.getThreshold());
        return true;
    }

    @Override
    public boolean handle(ServerLoginSuccess packet) {
        if (this.server.getConfiguration().getPlayerInfoForwardingMode() == PlayerInfoForwarding.MODERN && !this.informationForwarded) {
            this.resultFuture.complete(ConnectionRequestResults.forDisconnect(MODERN_IP_FORWARDING_FAILURE, (RegisteredServer)this.serverConn.getServer()));
            this.serverConn.disconnect();
            return true;
        }
        MinecraftConnection smc = this.serverConn.ensureConnected();
        smc.setState(StateRegistry.PLAY);
        smc.setSessionHandler(new TransitionSessionHandler(this.server, this.serverConn, this.resultFuture));
        return true;
    }

    @Override
    public void exception(Throwable throwable) {
        this.resultFuture.completeExceptionally(throwable);
    }

    @Override
    public void disconnected() {
        if (this.server.getConfiguration().getPlayerInfoForwardingMode() == PlayerInfoForwarding.LEGACY) {
            this.resultFuture.completeExceptionally(new QuietRuntimeException("The connection to the remote server was unexpectedly closed.\nThis is usually because the remote server does not have BungeeCord IP forwarding correctly enabled.\nSee https://velocitypowered.com/wiki/users/forwarding/ for instructions on how to configure player info forwarding correctly."));
        } else {
            this.resultFuture.completeExceptionally(new QuietRuntimeException("The connection to the remote server was unexpectedly closed."));
        }
    }

    private static ByteBuf createForwardingData(byte[] hmacSecret, String address, GameProfile profile) {
        ByteBuf forwarded = Unpooled.buffer(2048);
        try {
            ProtocolUtils.writeVarInt(forwarded, 1);
            ProtocolUtils.writeString(forwarded, address);
            ProtocolUtils.writeUuid(forwarded, profile.getId());
            ProtocolUtils.writeString(forwarded, profile.getName());
            ProtocolUtils.writeProperties(forwarded, profile.getProperties());
            SecretKeySpec key = new SecretKeySpec(hmacSecret, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(key);
            mac.update(forwarded.array(), forwarded.arrayOffset(), forwarded.readableBytes());
            byte[] sig = mac.doFinal();
            return Unpooled.wrappedBuffer(Unpooled.wrappedBuffer(sig), forwarded);
        }
        catch (InvalidKeyException e) {
            forwarded.release();
            throw new RuntimeException("Unable to authenticate data", e);
        }
        catch (NoSuchAlgorithmException e) {
            forwarded.release();
            throw new AssertionError((Object)e);
        }
    }
}

