/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.VelocityConstants;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;

public class EncryptionResponse
implements MinecraftPacket {
    private byte[] sharedSecret = VelocityConstants.EMPTY_BYTE_ARRAY;
    private byte[] verifyToken = VelocityConstants.EMPTY_BYTE_ARRAY;

    public byte[] getSharedSecret() {
        return (byte[])this.sharedSecret.clone();
    }

    public byte[] getVerifyToken() {
        return (byte[])this.verifyToken.clone();
    }

    public String toString() {
        return "EncryptionResponse{sharedSecret=" + Arrays.toString(this.sharedSecret) + ", verifyToken=" + Arrays.toString(this.verifyToken) + "}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            this.sharedSecret = ProtocolUtils.readByteArray(buf, 128);
            this.verifyToken = ProtocolUtils.readByteArray(buf, 128);
        } else {
            this.sharedSecret = ProtocolUtils.readByteArray17(buf);
            this.verifyToken = ProtocolUtils.readByteArray17(buf);
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            ProtocolUtils.writeByteArray(buf, this.sharedSecret);
            ProtocolUtils.writeByteArray(buf, this.verifyToken);
        } else {
            ProtocolUtils.writeByteArray17(this.sharedSecret, buf, false);
            ProtocolUtils.writeByteArray17(this.verifyToken, buf, false);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    @Override
    public int expectedMaxLength(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        return 260;
    }

    @Override
    public int expectedMinLength(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        return this.expectedMaxLength(buf, direction, version);
    }
}

