/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.proxy.messages;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import java.util.Objects;
import java.util.regex.Pattern;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MinecraftChannelIdentifier
implements ChannelIdentifier {
    private static final Pattern VALID_IDENTIFIER_REGEX = Pattern.compile("[a-z0-9/\\-_]*");
    private final String namespace;
    private final String name;

    private MinecraftChannelIdentifier(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    public static MinecraftChannelIdentifier forDefaultNamespace(String name) {
        return new MinecraftChannelIdentifier("minecraft", name);
    }

    public static MinecraftChannelIdentifier create(String namespace, String name) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(namespace), "namespace is null or empty");
        Preconditions.checkArgument(name != null, "namespace is null or empty");
        Preconditions.checkArgument(VALID_IDENTIFIER_REGEX.matcher(namespace).matches(), "namespace is not valid");
        Preconditions.checkArgument(VALID_IDENTIFIER_REGEX.matcher(name).matches(), "name is not valid");
        return new MinecraftChannelIdentifier(namespace, name);
    }

    public static MinecraftChannelIdentifier from(String identifier) {
        int colonPos = identifier.indexOf(58);
        if (colonPos == -1) {
            throw new IllegalArgumentException("Identifier does not contain a colon.");
        }
        if (colonPos + 1 == identifier.length()) {
            throw new IllegalArgumentException("Identifier is empty.");
        }
        String namespace = identifier.substring(0, colonPos);
        String name = identifier.substring(colonPos + 1);
        return MinecraftChannelIdentifier.create(namespace, name);
    }

    public static MinecraftChannelIdentifier from(Key key) {
        return MinecraftChannelIdentifier.create(key.namespace(), key.value());
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public Key asKey() {
        return Key.key(this.namespace, this.name);
    }

    public String toString() {
        return this.namespace + ":" + this.name + " (modern)";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinecraftChannelIdentifier that = (MinecraftChannelIdentifier)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.name);
    }

    @Override
    public String getId() {
        return this.namespace + ":" + this.name;
    }
}

