/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command.builtin;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.permission.Tristate;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.proxy.command.builtin.BuiltinCommandUtil;
import com.velocitypowered.proxy.command.builtin.CommandMessages;
import java.util.Optional;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class GlistCommand {
    private static final String SERVER_ARG = "server";
    private final ProxyServer server;

    public GlistCommand(ProxyServer server) {
        this.server = server;
    }

    public void register() {
        CommandNode totalNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("glist").requires(source -> source.getPermissionValue("velocity.command.glist") == Tristate.TRUE)).executes(this::totalCount)).build();
        CommandNode serverNode = ((RequiredArgumentBuilder)RequiredArgumentBuilder.argument(SERVER_ARG, StringArgumentType.string()).suggests((context, builder) -> {
            for (RegisteredServer server : this.server.getAllServers()) {
                builder.suggest(server.getServerInfo().getName());
            }
            builder.suggest("all");
            return builder.buildFuture();
        }).executes(this::serverCount)).build();
        totalNode.addChild(serverNode);
        this.server.getCommandManager().register(new BrigadierCommand((LiteralCommandNode<CommandSource>)totalNode));
    }

    private int totalCount(CommandContext<CommandSource> context) {
        CommandSource source = context.getSource();
        this.sendTotalProxyCount(source);
        source.sendMessage(Identity.nil(), (Component)Component.translatable("velocity.command.glist-view-all", (TextColor)NamedTextColor.YELLOW));
        return 1;
    }

    private int serverCount(CommandContext<CommandSource> context) {
        CommandSource source = context.getSource();
        String serverName = StringArgumentType.getString(context, SERVER_ARG);
        if (serverName.equalsIgnoreCase("all")) {
            for (RegisteredServer server : BuiltinCommandUtil.sortedServerList(this.server)) {
                this.sendServerPlayers(source, server, true);
            }
            this.sendTotalProxyCount(source);
        } else {
            Optional<RegisteredServer> registeredServer = this.server.getServer(serverName);
            if (!registeredServer.isPresent()) {
                source.sendMessage(Identity.nil(), (Component)CommandMessages.SERVER_DOES_NOT_EXIST.args(Component.text(serverName)));
                return -1;
            }
            this.sendServerPlayers(source, registeredServer.get(), false);
        }
        return 1;
    }

    private void sendTotalProxyCount(CommandSource target) {
        int online = this.server.getPlayerCount();
        TranslatableComponent msg = online == 1 ? Component.translatable("velocity.command.glist-player-singular") : Component.translatable("velocity.command.glist-player-plural");
        target.sendMessage(((TranslatableComponent)msg.color(NamedTextColor.YELLOW)).args(Component.text(Integer.toString(online), (TextColor)NamedTextColor.GREEN)));
    }

    private void sendServerPlayers(CommandSource target, RegisteredServer server, boolean fromAll) {
        ImmutableList<Player> onServer = ImmutableList.copyOf(server.getPlayersConnected());
        if (onServer.isEmpty() && fromAll) {
            return;
        }
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("[" + server.getServerInfo().getName() + "] ", (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.text("(" + onServer.size() + ")", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text(": "))).resetStyle();
        for (int i = 0; i < onServer.size(); ++i) {
            Player player = (Player)onServer.get(i);
            builder.append((Component)Component.text(player.getUsername()));
            if (i + 1 >= onServer.size()) continue;
            builder.append((Component)Component.text(", "));
        }
        target.sendMessage(Identity.nil(), (Component)builder.build());
    }
}

