/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.player.TabListEntry;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PlayerListItem
implements MinecraftPacket {
    public static final int ADD_PLAYER = 0;
    public static final int UPDATE_GAMEMODE = 1;
    public static final int UPDATE_LATENCY = 2;
    public static final int UPDATE_DISPLAY_NAME = 3;
    public static final int REMOVE_PLAYER = 4;
    private int action;
    private final List<Item> items = new ArrayList<Item>();

    public PlayerListItem(int action, List<Item> items) {
        this.action = action;
        this.items.addAll(items);
    }

    public PlayerListItem() {
    }

    public int getAction() {
        return this.action;
    }

    public List<Item> getItems() {
        return this.items;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            this.action = ProtocolUtils.readVarInt(buf);
            int length = ProtocolUtils.readVarInt(buf);
            block7: for (int i = 0; i < length; ++i) {
                Item item = new Item(ProtocolUtils.readUuid(buf));
                this.items.add(item);
                switch (this.action) {
                    case 0: {
                        item.setName(ProtocolUtils.readString(buf));
                        item.setProperties(ProtocolUtils.readProperties(buf));
                        item.setGameMode(ProtocolUtils.readVarInt(buf));
                        item.setLatency(ProtocolUtils.readVarInt(buf));
                        item.setDisplayName(PlayerListItem.readOptionalComponent(buf, version));
                        continue block7;
                    }
                    case 1: {
                        item.setGameMode(ProtocolUtils.readVarInt(buf));
                        continue block7;
                    }
                    case 2: {
                        item.setLatency(ProtocolUtils.readVarInt(buf));
                        continue block7;
                    }
                    case 3: {
                        item.setDisplayName(PlayerListItem.readOptionalComponent(buf, version));
                        continue block7;
                    }
                    case 4: {
                        continue block7;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown action " + this.action);
                    }
                }
            }
        } else {
            Item item = new Item();
            item.setName(ProtocolUtils.readString(buf));
            this.action = buf.readBoolean() ? 0 : 4;
            item.setLatency(buf.readShort());
            this.items.add(item);
        }
    }

    private static @Nullable Component readOptionalComponent(ByteBuf buf, ProtocolVersion version) {
        if (buf.readBoolean()) {
            return ProtocolUtils.getJsonChatSerializer(version).deserialize(ProtocolUtils.readString(buf));
        }
        return null;
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            ProtocolUtils.writeVarInt(buf, this.action);
            ProtocolUtils.writeVarInt(buf, this.items.size());
            block7: for (Item item : this.items) {
                UUID uuid = item.getUuid();
                assert (uuid != null) : "UUID-less entry serialization attempt - 1.7 component!";
                ProtocolUtils.writeUuid(buf, uuid);
                switch (this.action) {
                    case 0: {
                        ProtocolUtils.writeString(buf, item.getName());
                        ProtocolUtils.writeProperties(buf, item.getProperties());
                        ProtocolUtils.writeVarInt(buf, item.getGameMode());
                        ProtocolUtils.writeVarInt(buf, item.getLatency());
                        this.writeDisplayName(buf, item.getDisplayName(), version);
                        continue block7;
                    }
                    case 1: {
                        ProtocolUtils.writeVarInt(buf, item.getGameMode());
                        continue block7;
                    }
                    case 2: {
                        ProtocolUtils.writeVarInt(buf, item.getLatency());
                        continue block7;
                    }
                    case 3: {
                        this.writeDisplayName(buf, item.getDisplayName(), version);
                        continue block7;
                    }
                    case 4: {
                        continue block7;
                    }
                }
                throw new UnsupportedOperationException("Unknown action " + this.action);
            }
        } else {
            Item item = this.items.get(0);
            Component displayNameComponent = item.getDisplayName();
            if (displayNameComponent != null) {
                String displayName = LegacyComponentSerializer.legacySection().serialize(displayNameComponent);
                ProtocolUtils.writeString(buf, displayName.length() > 16 ? displayName.substring(0, 16) : displayName);
            } else {
                ProtocolUtils.writeString(buf, item.getName());
            }
            buf.writeBoolean(this.action != 4);
            buf.writeShort(item.getLatency());
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    private void writeDisplayName(ByteBuf buf, @Nullable Component displayName, ProtocolVersion version) {
        buf.writeBoolean(displayName != null);
        if (displayName != null) {
            ProtocolUtils.writeString(buf, (CharSequence)ProtocolUtils.getJsonChatSerializer(version).serialize(displayName));
        }
    }

    public static class Item {
        private final UUID uuid;
        private String name = "";
        private List<GameProfile.Property> properties = ImmutableList.of();
        private int gameMode;
        private int latency;
        private @Nullable Component displayName;

        public Item() {
            this.uuid = null;
        }

        public Item(UUID uuid) {
            this.uuid = uuid;
        }

        public static Item from(TabListEntry entry) {
            return new Item(entry.getProfile().getId()).setName(entry.getProfile().getName()).setProperties(entry.getProfile().getProperties()).setLatency(entry.getLatency()).setGameMode(entry.getGameMode()).setDisplayName(entry.getDisplayNameComponent().orElse(null));
        }

        public @Nullable UUID getUuid() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public Item setName(String name) {
            this.name = name;
            return this;
        }

        public List<GameProfile.Property> getProperties() {
            return this.properties;
        }

        public Item setProperties(List<GameProfile.Property> properties) {
            this.properties = properties;
            return this;
        }

        public int getGameMode() {
            return this.gameMode;
        }

        public Item setGameMode(int gameMode) {
            this.gameMode = gameMode;
            return this;
        }

        public int getLatency() {
            return this.latency;
        }

        public Item setLatency(int latency) {
            this.latency = latency;
            return this;
        }

        public @Nullable Component getDisplayName() {
            return this.displayName;
        }

        public Item setDisplayName(@Nullable Component displayName) {
            this.displayName = displayName;
            return this;
        }
    }
}

