/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat;

import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.BitSet;

public class LastSeenMessages {
    private static final int DIV_FLOOR = -Math.floorDiv(-20, 8);
    private int offset;
    private BitSet acknowledged;

    public LastSeenMessages() {
        this.offset = 0;
        this.acknowledged = new BitSet();
    }

    public LastSeenMessages(ByteBuf buf) {
        this.offset = ProtocolUtils.readVarInt(buf);
        byte[] bytes = new byte[DIV_FLOOR];
        buf.readBytes(bytes);
        this.acknowledged = BitSet.valueOf(bytes);
    }

    public void encode(ByteBuf buf) {
        ProtocolUtils.writeVarInt(buf, this.offset);
        buf.writeBytes(Arrays.copyOf(this.acknowledged.toByteArray(), DIV_FLOOR));
    }

    public boolean isEmpty() {
        return this.acknowledged.isEmpty();
    }
}

