/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.keyed;

import com.google.common.primitives.Longs;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.crypto.EncryptionUtils;
import com.velocitypowered.proxy.crypto.SignaturePair;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import io.netty.buffer.ByteBuf;
import java.time.Instant;
import org.checkerframework.checker.nullness.qual.Nullable;

public class KeyedPlayerChat
implements MinecraftPacket {
    private String message;
    private boolean signedPreview;
    private boolean unsigned = false;
    private @Nullable Instant expiry;
    private @Nullable byte[] signature;
    private @Nullable byte[] salt;
    private SignaturePair[] previousMessages = new SignaturePair[0];
    private @Nullable SignaturePair lastMessage;
    public static final int MAXIMUM_PREVIOUS_MESSAGE_COUNT = 5;
    public static final QuietDecoderException INVALID_PREVIOUS_MESSAGES = new QuietDecoderException("Invalid previous messages");

    public KeyedPlayerChat() {
    }

    public KeyedPlayerChat(String message) {
        this.message = message;
        this.unsigned = true;
    }

    public void setExpiry(@Nullable Instant expiry) {
        this.expiry = expiry;
    }

    public Instant getExpiry() {
        return this.expiry;
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isSignedPreview() {
        return this.signedPreview;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        this.message = ProtocolUtils.readString(buf, 256);
        long expiresAt = buf.readLong();
        long saltLong = buf.readLong();
        byte[] signatureBytes = ProtocolUtils.readByteArray(buf);
        if (saltLong != 0L && signatureBytes.length > 0) {
            this.salt = Longs.toByteArray(saltLong);
            this.signature = signatureBytes;
            this.expiry = Instant.ofEpochMilli(expiresAt);
        } else if ((protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_1) >= 0 || saltLong == 0L) && signatureBytes.length == 0) {
            this.unsigned = true;
        } else {
            throw EncryptionUtils.INVALID_SIGNATURE;
        }
        this.signedPreview = buf.readBoolean();
        if (this.signedPreview && this.unsigned) {
            throw EncryptionUtils.PREVIEW_SIGNATURE_MISSING;
        }
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_1) >= 0) {
            int size = ProtocolUtils.readVarInt(buf);
            if (size < 0 || size > 5) {
                throw INVALID_PREVIOUS_MESSAGES;
            }
            SignaturePair[] lastSignatures = new SignaturePair[size];
            for (int i = 0; i < size; ++i) {
                lastSignatures[i] = new SignaturePair(ProtocolUtils.readUuid(buf), ProtocolUtils.readByteArray(buf));
            }
            this.previousMessages = lastSignatures;
            if (buf.readBoolean()) {
                this.lastMessage = new SignaturePair(ProtocolUtils.readUuid(buf), ProtocolUtils.readByteArray(buf));
            }
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ProtocolUtils.writeString(buf, this.message);
        buf.writeLong(this.unsigned ? Instant.now().toEpochMilli() : this.expiry.toEpochMilli());
        buf.writeLong(this.unsigned ? 0L : Longs.fromByteArray(this.salt));
        ProtocolUtils.writeByteArray(buf, this.unsigned ? EncryptionUtils.EMPTY : this.signature);
        buf.writeBoolean(this.signedPreview);
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_1) >= 0) {
            ProtocolUtils.writeVarInt(buf, this.previousMessages.length);
            for (SignaturePair previousMessage : this.previousMessages) {
                ProtocolUtils.writeUuid(buf, previousMessage.getSigner());
                ProtocolUtils.writeByteArray(buf, previousMessage.getSignature());
            }
            if (this.lastMessage != null) {
                buf.writeBoolean(true);
                ProtocolUtils.writeUuid(buf, this.lastMessage.getSigner());
                ProtocolUtils.writeByteArray(buf, this.lastMessage.getSignature());
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

