/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;

public class FileSystemUtils {
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public static boolean visitResources(Class<?> target, Consumer<Path> consumer, String firstPathComponent, String ... remainingPathComponents) throws IOException {
        URI uri;
        URL knownResource = FileSystemUtils.class.getClassLoader().getResource("default-velocity.toml");
        if (knownResource == null) {
            throw new IllegalStateException("default-velocity.toml does not exist, don't know where we are");
        }
        if (knownResource.getProtocol().equals("jar")) {
            String jarPathRaw = knownResource.toString().split("!")[0];
            URI path = URI.create(jarPathRaw + "!/");
            try (FileSystem fileSystem = FileSystems.newFileSystem(path, Map.of("create", "true"));){
                Path toVisit = fileSystem.getPath(firstPathComponent, remainingPathComponents);
                if (Files.exists(toVisit, new LinkOption[0])) {
                    consumer.accept(toVisit);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        ArrayList<String> componentList = new ArrayList<String>();
        componentList.add(firstPathComponent);
        componentList.addAll(Arrays.asList(remainingPathComponents));
        try {
            URL url = target.getClassLoader().getResource(String.join((CharSequence)"/", componentList));
            if (url == null) {
                return false;
            }
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        consumer.accept(Path.of(uri));
        return true;
    }
}

