/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.proxy.command.CommandGraphInjector;
import com.velocitypowered.proxy.command.SuggestionsProvider;
import com.velocitypowered.proxy.command.VelocityCommandMeta;
import com.velocitypowered.proxy.command.VelocityCommands;
import com.velocitypowered.proxy.command.registrar.BrigadierCommandRegistrar;
import com.velocitypowered.proxy.command.registrar.CommandRegistrar;
import com.velocitypowered.proxy.command.registrar.RawCommandRegistrar;
import com.velocitypowered.proxy.command.registrar.SimpleCommandRegistrar;
import com.velocitypowered.proxy.event.VelocityEventManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class VelocityCommandManager
implements CommandManager {
    private final @GuardedBy(value={"lock"}) CommandDispatcher<CommandSource> dispatcher;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final VelocityEventManager eventManager;
    private final List<CommandRegistrar<?>> registrars;
    private final SuggestionsProvider<CommandSource> suggestionsProvider;
    private final CommandGraphInjector<CommandSource> injector;
    private final Map<String, CommandMeta> commandMetas;

    public VelocityCommandManager(VelocityEventManager eventManager) {
        this.dispatcher = new CommandDispatcher();
        this.eventManager = Preconditions.checkNotNull(eventManager);
        RootCommandNode<CommandSource> root = this.dispatcher.getRoot();
        this.registrars = ImmutableList.of(new BrigadierCommandRegistrar(root, this.lock.writeLock()), new SimpleCommandRegistrar(root, this.lock.writeLock()), new RawCommandRegistrar(root, this.lock.writeLock()));
        this.suggestionsProvider = new SuggestionsProvider<CommandSource>(this.dispatcher, this.lock.readLock());
        this.injector = new CommandGraphInjector<CommandSource>(this.dispatcher, this.lock.readLock());
        this.commandMetas = new ConcurrentHashMap<String, CommandMeta>();
    }

    public void setAnnounceProxyCommands(boolean announceProxyCommands) {
        this.suggestionsProvider.setAnnounceProxyCommands(announceProxyCommands);
    }

    @Override
    public CommandMeta.Builder metaBuilder(String alias) {
        Preconditions.checkNotNull(alias, "alias");
        return new VelocityCommandMeta.Builder(alias);
    }

    @Override
    public CommandMeta.Builder metaBuilder(BrigadierCommand command) {
        Preconditions.checkNotNull(command, "command");
        return new VelocityCommandMeta.Builder(command.getNode().getName());
    }

    @Override
    public void register(BrigadierCommand command) {
        Preconditions.checkNotNull(command, "command");
        this.register(this.metaBuilder(command).build(), command);
    }

    @Override
    public void register(CommandMeta meta, Command command) {
        Preconditions.checkNotNull(meta, "meta");
        Preconditions.checkNotNull(command, "command");
        List<CommandRegistrar<?>> commandRegistrars = this.implementedRegistrars(command);
        if (commandRegistrars.isEmpty()) {
            throw new IllegalArgumentException(command + " does not implement a registrable Command subinterface");
        }
        if (commandRegistrars.size() > 1) {
            String implementedInterfaces = commandRegistrars.stream().map(CommandRegistrar::registrableSuperInterface).map(Class::getSimpleName).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(command + " implements multiple registrable Command subinterfaces: " + implementedInterfaces);
        }
        this.internalRegister(commandRegistrars.get(0), command, meta);
    }

    private <T extends Command> void internalRegister(CommandRegistrar<T> registrar, Command command, CommandMeta meta) {
        Class<T> superInterface = registrar.registrableSuperInterface();
        registrar.register(meta, (Command)superInterface.cast(command));
        for (String alias : meta.getAliases()) {
            this.commandMetas.put(alias, meta);
        }
    }

    private List<CommandRegistrar<?>> implementedRegistrars(Command command) {
        ArrayList registrarsFound = new ArrayList(2);
        for (CommandRegistrar<?> registrar : this.registrars) {
            Class<?> superInterface = registrar.registrableSuperInterface();
            if (!superInterface.isInstance(command)) continue;
            registrarsFound.add(registrar);
        }
        return registrarsFound;
    }

    @Override
    public void unregister(String alias) {
        Preconditions.checkNotNull(alias, "alias");
        this.lock.writeLock().lock();
        try {
            this.dispatcher.getRoot().removeChildByName(alias.toLowerCase(Locale.ENGLISH));
            this.commandMetas.remove(alias);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(CommandMeta meta) {
        Preconditions.checkNotNull(meta, "meta");
        this.lock.writeLock().lock();
        try {
            for (String alias : meta.getAliases()) {
                String lowercased = alias.toLowerCase(Locale.ENGLISH);
                if (!this.commandMetas.remove(lowercased, meta)) continue;
                this.dispatcher.getRoot().removeChildByName(lowercased);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public @Nullable CommandMeta getCommandMeta(String alias) {
        Preconditions.checkNotNull(alias, "alias");
        return this.commandMetas.get(alias);
    }

    public CompletableFuture<CommandExecuteEvent> callCommandEvent(CommandSource source, String cmdLine) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(cmdLine, "cmdLine");
        return this.eventManager.fire(new CommandExecuteEvent(source, cmdLine));
    }

    private boolean executeImmediately0(CommandSource source, String cmdLine) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(cmdLine, "cmdLine");
        String normalizedInput = VelocityCommands.normalizeInput(cmdLine, true);
        try {
            ParseResults<CommandSource> parse = this.parse(normalizedInput, source);
            return this.dispatcher.execute(parse) != -165120983;
        }
        catch (CommandSyntaxException e) {
            boolean isSyntaxError;
            boolean bl = isSyntaxError = !e.getType().equals(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand());
            if (isSyntaxError) {
                source.sendMessage(Component.text(e.getMessage(), (TextColor)NamedTextColor.RED));
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to invoke command " + cmdLine + " for " + source, e);
        }
    }

    @Override
    public CompletableFuture<Boolean> executeAsync(CommandSource source, String cmdLine) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(cmdLine, "cmdLine");
        return this.callCommandEvent(source, cmdLine).thenApplyAsync(event -> {
            CommandExecuteEvent.CommandResult commandResult = event.getResult();
            if (commandResult.isForwardToServer() || !commandResult.isAllowed()) {
                return false;
            }
            return this.executeImmediately0(source, commandResult.getCommand().orElse(event.getCommand()));
        }, (Executor)this.eventManager.getAsyncExecutor());
    }

    @Override
    public CompletableFuture<Boolean> executeImmediatelyAsync(CommandSource source, String cmdLine) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(cmdLine, "cmdLine");
        return CompletableFuture.supplyAsync(() -> this.executeImmediately0(source, cmdLine), this.eventManager.getAsyncExecutor());
    }

    public CompletableFuture<List<String>> offerSuggestions(CommandSource source, String cmdLine) {
        return this.offerBrigadierSuggestions(source, cmdLine).thenApply(suggestions -> Lists.transform(suggestions.getList(), Suggestion::getText));
    }

    public CompletableFuture<Suggestions> offerBrigadierSuggestions(CommandSource source, String cmdLine) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(cmdLine, "cmdLine");
        String normalizedInput = VelocityCommands.normalizeInput(cmdLine, false);
        try {
            return this.suggestionsProvider.provideSuggestions(normalizedInput, source);
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(new RuntimeException("Unable to provide suggestions for " + cmdLine + " for " + source, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResults<CommandSource> parse(String input, CommandSource source) {
        this.lock.readLock().lock();
        try {
            ParseResults<CommandSource> parseResults = this.dispatcher.parse(input, source);
            return parseResults;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<String> getAliases() {
        this.lock.readLock().lock();
        try {
            Collection collection = this.dispatcher.getRoot().getChildren().stream().map(CommandNode::getName).collect(ImmutableList.toImmutableList());
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean hasCommand(String alias) {
        Preconditions.checkNotNull(alias, "alias");
        return this.dispatcher.getRoot().getChild(alias.toLowerCase(Locale.ENGLISH)) != null;
    }

    @VisibleForTesting
    RootCommandNode<CommandSource> getRoot() {
        return this.dispatcher.getRoot();
    }

    public CommandGraphInjector<CommandSource> getInjector() {
        return this.injector;
    }
}

