/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command.builtin;

import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.permission.Tristate;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import com.velocitypowered.proxy.command.builtin.BuiltinCommandUtil;
import com.velocitypowered.proxy.command.builtin.CommandMessages;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class ServerCommand
implements SimpleCommand {
    public static final int MAX_SERVERS_TO_LIST = 50;
    private final ProxyServer server;

    public ServerCommand(ProxyServer server) {
        this.server = server;
    }

    @Override
    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        String[] args = (String[])invocation.arguments();
        if (!(source instanceof Player)) {
            source.sendMessage(CommandMessages.PLAYERS_ONLY);
            return;
        }
        Player player = (Player)source;
        if (args.length == 1) {
            String serverName = args[0];
            Optional<RegisteredServer> toConnect = this.server.getServer(serverName);
            if (toConnect.isEmpty()) {
                player.sendMessage(CommandMessages.SERVER_DOES_NOT_EXIST.args(Component.text(serverName)));
                return;
            }
            player.createConnectionRequest(toConnect.get()).fireAndForget();
        } else {
            this.outputServerInformation(player);
        }
    }

    private void outputServerInformation(Player executor) {
        String currentServer = executor.getCurrentServer().map(ServerConnection::getServerInfo).map(ServerInfo::getName).orElse("<unknown>");
        executor.sendMessage(Component.translatable("velocity.command.server-current-server", (TextColor)NamedTextColor.YELLOW, Component.text(currentServer)));
        List<RegisteredServer> servers = BuiltinCommandUtil.sortedServerList(this.server);
        if (servers.size() > 50) {
            executor.sendMessage(Component.translatable("velocity.command.server-too-many", (TextColor)NamedTextColor.RED));
            return;
        }
        TextComponent.Builder serverListBuilder = (TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.translatable("velocity.command.server-available", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.space());
        for (int i = 0; i < servers.size(); ++i) {
            RegisteredServer rs = servers.get(i);
            serverListBuilder.append((Component)this.formatServerComponent(currentServer, rs));
            if (i == servers.size() - 1) continue;
            serverListBuilder.append((Component)Component.text(", ", (TextColor)NamedTextColor.GRAY));
        }
        executor.sendMessage((Component)serverListBuilder.build());
    }

    private TextComponent formatServerComponent(String currentPlayerServer, RegisteredServer server) {
        ServerInfo serverInfo = server.getServerInfo();
        TextComponent serverTextComponent = Component.text(serverInfo.getName());
        int connectedPlayers = server.getPlayersConnected().size();
        TranslatableComponent playersTextComponent = connectedPlayers == 1 ? Component.translatable("velocity.command.server-tooltip-player-online") : Component.translatable("velocity.command.server-tooltip-players-online");
        playersTextComponent = playersTextComponent.args(Component.text(connectedPlayers));
        serverTextComponent = serverInfo.getName().equals(currentPlayerServer) ? (TextComponent)((TextComponent)serverTextComponent.color(NamedTextColor.GREEN)).hoverEvent(HoverEvent.showText(((TranslatableComponent)Component.translatable("velocity.command.server-tooltip-current-server").append(Component.newline())).append(playersTextComponent))) : (TextComponent)((TextComponent)((TextComponent)serverTextComponent.color(NamedTextColor.GRAY)).clickEvent(ClickEvent.runCommand("/server " + serverInfo.getName()))).hoverEvent(HoverEvent.showText(((TranslatableComponent)Component.translatable("velocity.command.server-tooltip-offer-connect-server").append(Component.newline())).append(playersTextComponent)));
        return serverTextComponent;
    }

    @Override
    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String[] currentArgs = (String[])invocation.arguments();
        Stream<String> possibilities = this.server.getAllServers().stream().map(rs -> rs.getServerInfo().getName());
        if (currentArgs.length == 0) {
            return possibilities.collect(Collectors.toList());
        }
        if (currentArgs.length == 1) {
            return possibilities.filter(name -> name.regionMatches(true, 0, currentArgs[0], 0, currentArgs[0].length())).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }

    @Override
    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().getPermissionValue("velocity.command.server") != Tristate.FALSE;
    }
}

