/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command.registrar;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.velocitypowered.api.command.CommandInvocation;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.InvocableCommand;
import com.velocitypowered.proxy.command.VelocityCommandMeta;
import com.velocitypowered.proxy.command.brigadier.VelocityArgumentBuilder;
import com.velocitypowered.proxy.command.invocation.CommandInvocationFactory;
import com.velocitypowered.proxy.command.registrar.AbstractCommandRegistrar;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.function.Predicate;

abstract class InvocableCommandRegistrar<T extends InvocableCommand<I>, I extends CommandInvocation<A>, A>
extends AbstractCommandRegistrar<T> {
    private final CommandInvocationFactory<I> invocationFactory;
    private final ArgumentType<A> argumentsType;

    protected InvocableCommandRegistrar(RootCommandNode<CommandSource> root, Lock lock, CommandInvocationFactory<I> invocationFactory, ArgumentType<A> argumentsType) {
        super(root, lock);
        this.invocationFactory = Preconditions.checkNotNull(invocationFactory, "invocationFactory");
        this.argumentsType = Preconditions.checkNotNull(argumentsType, "argumentsType");
    }

    @Override
    public void register(CommandMeta meta, T command) {
        Iterator<String> aliases = meta.getAliases().iterator();
        String primaryAlias = aliases.next();
        LiteralCommandNode<CommandSource> literal = this.createLiteral(command, meta, primaryAlias);
        this.register(literal);
        while (aliases.hasNext()) {
            String alias = aliases.next();
            this.register(literal, alias);
        }
    }

    private LiteralCommandNode<CommandSource> createLiteral(T command, CommandMeta meta, String alias) {
        Predicate<CommandContextBuilder> requirement = context -> {
            I invocation = this.invocationFactory.create((CommandContextBuilder<CommandSource>)context);
            return command.hasPermission(invocation);
        };
        Command callback = context -> {
            I invocation = this.invocationFactory.create(context);
            command.execute(invocation);
            return 1;
        };
        CommandNode literal = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal(alias).requiresWithContext((context, reader) -> {
            if (reader.canRead()) {
                return true;
            }
            return requirement.test((CommandContextBuilder)context);
        })).executes(callback)).build();
        CommandNode arguments = ((VelocityArgumentBuilder)((VelocityArgumentBuilder)VelocityArgumentBuilder.velocityArgument("arguments", this.argumentsType).requiresWithContext((context, reader) -> requirement.test((CommandContextBuilder)context))).executes(callback)).suggests((context, builder) -> {
            I invocation = this.invocationFactory.create(context);
            return command.suggestAsync(invocation).thenApply(suggestions -> {
                for (String value : suggestions) {
                    Preconditions.checkNotNull(value, "suggestion");
                    builder.suggest(value);
                }
                return builder.build();
            });
        }).build();
        literal.addChild(arguments);
        VelocityCommandMeta.copyHints(meta).forEach(((LiteralCommandNode)literal)::addChild);
        return literal;
    }
}

