/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.util;

import com.google.common.collect.ImmutableList;
import com.spotify.futures.CompletableFutures;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.server.PingOptions;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import com.velocitypowered.api.util.ModInfo;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.config.PingPassthroughMode;
import com.velocitypowered.proxy.config.VelocityConfiguration;
import com.velocitypowered.proxy.connection.util.VelocityInboundConnection;
import com.velocitypowered.proxy.server.VelocityRegisteredServer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class ServerListPingHandler {
    private final VelocityServer server;

    public ServerListPingHandler(VelocityServer server) {
        this.server = server;
    }

    private ServerPing constructLocalPing(ProtocolVersion version) {
        if (version == ProtocolVersion.UNKNOWN) {
            version = ProtocolVersion.MAXIMUM_VERSION;
        }
        VelocityConfiguration configuration = this.server.getConfiguration();
        return new ServerPing(new ServerPing.Version(version.getProtocol(), "Velocity " + ProtocolVersion.SUPPORTED_VERSION_STRING), new ServerPing.Players(this.server.getPlayerCount(), configuration.getShowMaxPlayers(), ImmutableList.of()), configuration.getMotd(), configuration.getFavicon().orElse(null), configuration.isAnnounceForge() ? ModInfo.DEFAULT : null);
    }

    private CompletableFuture<ServerPing> attemptPingPassthrough(VelocityInboundConnection connection, PingPassthroughMode mode, List<String> servers, ProtocolVersion responseProtocolVersion) {
        ServerPing fallback = this.constructLocalPing(connection.getProtocolVersion());
        ArrayList<CompletableFuture<ServerPing>> pings = new ArrayList<CompletableFuture<ServerPing>>();
        for (String s : servers) {
            Optional<RegisteredServer> rs = this.server.getServer(s);
            if (rs.isEmpty()) continue;
            VelocityRegisteredServer vrs = (VelocityRegisteredServer)rs.get();
            pings.add(vrs.ping(connection.getConnection().eventLoop(), PingOptions.builder().version(responseProtocolVersion).build()));
        }
        if (pings.isEmpty()) {
            return CompletableFuture.completedFuture(fallback);
        }
        CompletableFuture<List<ServerPing>> pingResponses = CompletableFutures.successfulAsList(pings, ex -> fallback);
        switch (mode) {
            case ALL: {
                return pingResponses.thenApply(responses -> {
                    for (ServerPing response : responses) {
                        if (response == fallback) continue;
                        return response;
                    }
                    return fallback;
                });
            }
            case MODS: {
                return pingResponses.thenApply(responses -> {
                    for (ServerPing response : responses) {
                        Optional<ModInfo> modInfo;
                        if (response == fallback || !(modInfo = response.getModinfo()).isPresent()) continue;
                        return fallback.asBuilder().mods(modInfo.get()).build();
                    }
                    return fallback;
                });
            }
            case DESCRIPTION: {
                return pingResponses.thenApply(responses -> {
                    for (ServerPing response : responses) {
                        if (response == fallback || response.getDescriptionComponent() == null) continue;
                        return new ServerPing(fallback.getVersion(), fallback.getPlayers().orElse(null), response.getDescriptionComponent(), fallback.getFavicon().orElse(null), response.getModinfo().orElse(null));
                    }
                    return fallback;
                });
            }
        }
        return CompletableFuture.completedFuture(fallback);
    }

    public CompletableFuture<ServerPing> getInitialPing(VelocityInboundConnection connection) {
        VelocityConfiguration configuration = this.server.getConfiguration();
        ProtocolVersion shownVersion = ProtocolVersion.isSupported(connection.getProtocolVersion()) ? connection.getProtocolVersion() : ProtocolVersion.MAXIMUM_VERSION;
        PingPassthroughMode passthroughMode = configuration.getPingPassthrough();
        if (passthroughMode == PingPassthroughMode.DISABLED) {
            return CompletableFuture.completedFuture(this.constructLocalPing(shownVersion));
        }
        String virtualHostStr = connection.getVirtualHost().map(InetSocketAddress::getHostString).map(str -> str.toLowerCase(Locale.ROOT)).orElse("");
        List<String> serversToTry = this.server.getConfiguration().getForcedHosts().getOrDefault(virtualHostStr, this.server.getConfiguration().getAttemptConnectionOrder());
        return this.attemptPingPassthrough(connection, passthroughMode, serversToTry, shownVersion);
    }
}

