/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.netty;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class PlayPacketQueueHandler
extends ChannelDuplexHandler {
    private final StateRegistry.PacketRegistry.ProtocolRegistry registry;
    private final Queue<MinecraftPacket> queue = PlatformDependent.newMpscQueue();

    public PlayPacketQueueHandler(ProtocolVersion version, ProtocolUtils.Direction direction) {
        this.registry = StateRegistry.CONFIG.getProtocolRegistry(direction, version);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof MinecraftPacket)) {
            ctx.write(msg, promise);
            return;
        }
        if (this.registry.containsPacket((MinecraftPacket)msg)) {
            ctx.write(msg, promise);
            return;
        }
        this.queue.offer((MinecraftPacket)msg);
    }

    @Override
    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        this.releaseQueue(ctx, false);
        super.channelInactive(ctx);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.releaseQueue(ctx, ctx.channel().isActive());
    }

    private void releaseQueue(ChannelHandlerContext ctx, boolean active) {
        MinecraftPacket packet;
        if (this.queue.isEmpty()) {
            return;
        }
        while ((packet = this.queue.poll()) != null) {
            if (active) {
                ctx.write(packet, ctx.voidPromise());
                continue;
            }
            ReferenceCountUtil.release(packet);
        }
        if (active) {
            ctx.flush();
        }
    }
}

