/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.util.DeferredByteBufHolder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class LoginPluginResponse
extends DeferredByteBufHolder
implements MinecraftPacket {
    private int id;
    private boolean success;

    public LoginPluginResponse() {
        super(Unpooled.EMPTY_BUFFER);
    }

    public LoginPluginResponse(int id, boolean success, @MonotonicNonNull ByteBuf buf) {
        super(buf);
        this.id = id;
        this.success = success;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public String toString() {
        return "LoginPluginResponse{id=" + this.id + ", success=" + this.success + ", data=" + super.toString() + "}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.id = ProtocolUtils.readVarInt(buf);
        this.success = buf.readBoolean();
        if (buf.isReadable()) {
            this.replace(buf.readRetainedSlice(buf.readableBytes()));
        } else {
            this.replace(Unpooled.EMPTY_BUFFER);
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        ProtocolUtils.writeVarInt(buf, this.id);
        buf.writeBoolean(this.success);
        buf.writeBytes(this.content());
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

