/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.player.VelocityResourcePackInfo;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ResourcePackRequest
implements MinecraftPacket {
    private @MonotonicNonNull String url;
    private @MonotonicNonNull String hash;
    private boolean isRequired;
    private @Nullable Component prompt;
    private static final Pattern PLAUSIBLE_SHA1_HASH = Pattern.compile("^[a-z0-9]{40}$");

    public @Nullable String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public @Nullable String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    public @Nullable Component getPrompt() {
        return this.prompt;
    }

    public void setPrompt(Component prompt) {
        this.prompt = prompt;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        this.url = ProtocolUtils.readString(buf);
        this.hash = ProtocolUtils.readString(buf);
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_17) >= 0) {
            this.isRequired = buf.readBoolean();
            this.prompt = buf.readBoolean() ? GsonComponentSerializer.gson().deserialize(ProtocolUtils.readString(buf)) : null;
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        if (this.url == null || this.hash == null) {
            throw new IllegalStateException("Packet not fully filled in yet!");
        }
        ProtocolUtils.writeString(buf, this.url);
        ProtocolUtils.writeString(buf, this.hash);
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_17) >= 0) {
            buf.writeBoolean(this.isRequired);
            if (this.prompt != null) {
                buf.writeBoolean(true);
                ProtocolUtils.writeString(buf, (CharSequence)GsonComponentSerializer.gson().serialize(this.prompt));
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    public VelocityResourcePackInfo toServerPromptedPack() {
        VelocityResourcePackInfo.BuilderImpl builder = new VelocityResourcePackInfo.BuilderImpl(Preconditions.checkNotNull(this.url)).setPrompt(this.prompt).setShouldForce(this.isRequired).setOrigin(ResourcePackInfo.Origin.DOWNSTREAM_SERVER);
        if (this.hash != null && !this.hash.isEmpty() && PLAUSIBLE_SHA1_HASH.matcher(this.hash).matches()) {
            builder.setHash(ByteBufUtil.decodeHexDump(this.hash));
        }
        return (VelocityResourcePackInfo)builder.build();
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    public String toString() {
        return "ResourcePackRequest{url='" + this.url + "', hash='" + this.hash + "', isRequired=" + this.isRequired + ", prompt='" + this.prompt + "'}";
    }
}

