/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.util.Favicon;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class ServerData
implements MinecraftPacket {
    @Nullable
    private Component description;
    @Nullable
    private Favicon favicon;
    private boolean secureChatEnforced;

    public ServerData() {
    }

    public ServerData(@Nullable Component description, @Nullable Favicon favicon, boolean secureChatEnforced) {
        this.description = description;
        this.favicon = favicon;
        this.secureChatEnforced = secureChatEnforced;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_4) >= 0 || buf.readBoolean()) {
            this.description = ProtocolUtils.getJsonChatSerializer(protocolVersion).deserialize(ProtocolUtils.readString(buf));
        }
        if (buf.readBoolean()) {
            Object iconBase64;
            if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_4) >= 0) {
                byte[] iconBytes = ProtocolUtils.readByteArray(buf);
                iconBase64 = "data:image/png;base64," + new String(Base64.getEncoder().encode(iconBytes), StandardCharsets.UTF_8);
            } else {
                iconBase64 = ProtocolUtils.readString(buf);
            }
            this.favicon = new Favicon((String)iconBase64);
        }
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_3) < 0) {
            buf.readBoolean();
        }
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_1) >= 0) {
            this.secureChatEnforced = buf.readBoolean();
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        boolean hasDescription;
        boolean bl = hasDescription = this.description != null;
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_4) < 0) {
            buf.writeBoolean(hasDescription);
        }
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_4) >= 0 || hasDescription) {
            ProtocolUtils.writeString(buf, (CharSequence)ProtocolUtils.getJsonChatSerializer(protocolVersion).serialize(this.description));
        }
        boolean hasFavicon = this.favicon != null;
        buf.writeBoolean(hasFavicon);
        if (hasFavicon) {
            if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_4) >= 0) {
                String cutIconBase64 = this.favicon.getBase64Url().substring("data:image/png;base64,".length());
                byte[] iconBytes = Base64.getDecoder().decode(cutIconBase64.getBytes(StandardCharsets.UTF_8));
                ProtocolUtils.writeByteArray(buf, iconBytes);
            } else {
                ProtocolUtils.writeString(buf, this.favicon.getBase64Url());
            }
        }
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_3) < 0) {
            buf.writeBoolean(false);
        }
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_1) >= 0) {
            buf.writeBoolean(this.secureChatEnforced);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    @Nullable
    public Component getDescription() {
        return this.description;
    }

    @Nullable
    public Favicon getFavicon() {
        return this.favicon;
    }

    public boolean isSecureChatEnforced() {
        return this.secureChatEnforced;
    }
}

