/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.keyed;

import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.event.VelocityEventManager;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.packet.chat.ChatHandler;
import com.velocitypowered.proxy.protocol.packet.chat.ChatQueue;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedPlayerChat;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyedChatHandler
implements ChatHandler<KeyedPlayerChat> {
    private static final Logger logger = LogManager.getLogger(KeyedChatHandler.class);
    private final VelocityServer server;
    private final ConnectedPlayer player;

    public KeyedChatHandler(VelocityServer server, ConnectedPlayer player) {
        this.server = server;
        this.player = player;
    }

    @Override
    public Class<KeyedPlayerChat> packetClass() {
        return KeyedPlayerChat.class;
    }

    public static void invalidCancel(Logger logger, ConnectedPlayer player) {
        logger.fatal("A plugin tried to cancel a signed chat message. This is no longer possible in 1.19.1 and newer. Disconnecting player " + player.getUsername());
        player.disconnect(Component.text("A proxy plugin caused an illegal protocol state. Contact your network administrator."));
    }

    public static void invalidChange(Logger logger, ConnectedPlayer player) {
        logger.fatal("A plugin tried to change a signed chat message. This is no longer possible in 1.19.1 and newer. Disconnecting player " + player.getUsername());
        player.disconnect(Component.text("A proxy plugin caused an illegal protocol state. Contact your network administrator."));
    }

    @Override
    public void handlePlayerChatInternal(KeyedPlayerChat packet) {
        ChatQueue chatQueue = this.player.getChatQueue();
        VelocityEventManager eventManager = this.server.getEventManager();
        PlayerChatEvent toSend = new PlayerChatEvent(this.player, packet.getMessage());
        CompletableFuture<PlayerChatEvent> future = eventManager.fire(toSend);
        IdentifiedKey playerKey = this.player.getIdentifiedKey();
        CompletionStage chatFuture = playerKey != null && !packet.isUnsigned() ? future.thenApply(this.handleOldSignedChat(packet)) : future.thenApply(pme -> {
            PlayerChatEvent.ChatResult chatResult = pme.getResult();
            if (!chatResult.isAllowed()) {
                return null;
            }
            return this.player.getChatBuilderFactory().builder().message(chatResult.getMessage().orElse(packet.getMessage())).setTimestamp(packet.getExpiry()).toServer();
        });
        chatQueue.queuePacket((CompletableFuture<MinecraftPacket>)((CompletableFuture)chatFuture).exceptionally(ex -> {
            logger.error("Exception while handling player chat for {}", (Object)this.player, ex);
            return null;
        }), packet.getExpiry());
    }

    private Function<PlayerChatEvent, MinecraftPacket> handleOldSignedChat(KeyedPlayerChat packet) {
        IdentifiedKey playerKey = this.player.getIdentifiedKey();
        assert (playerKey != null);
        return pme -> {
            PlayerChatEvent.ChatResult chatResult = pme.getResult();
            if (!chatResult.isAllowed()) {
                if (playerKey.getKeyRevision().compareTo(IdentifiedKey.Revision.LINKED_V2) >= 0) {
                    KeyedChatHandler.invalidCancel(logger, this.player);
                }
                return null;
            }
            if (chatResult.getMessage().map(str -> !str.equals(packet.getMessage())).orElse(false).booleanValue()) {
                if (playerKey.getKeyRevision().compareTo(IdentifiedKey.Revision.LINKED_V2) >= 0) {
                    KeyedChatHandler.invalidChange(logger, this.player);
                } else {
                    logger.warn("A plugin changed a signed chat message. The server may not accept it.");
                    return this.player.getChatBuilderFactory().builder().message(chatResult.getMessage().get()).setTimestamp(packet.getExpiry()).toServer();
                }
            }
            return packet;
        };
    }
}

