/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.tablist;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.api.proxy.player.ChatSession;
import com.velocitypowered.api.proxy.player.TabListEntry;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.LegacyPlayerListItem;
import com.velocitypowered.proxy.protocol.packet.chat.RemoteChatSession;
import com.velocitypowered.proxy.tablist.InternalTabList;
import com.velocitypowered.proxy.tablist.KeyedVelocityTabListEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;

public class KeyedVelocityTabList
implements InternalTabList {
    protected final ConnectedPlayer player;
    protected final MinecraftConnection connection;
    protected final ProxyServer proxyServer;
    protected final Map<UUID, KeyedVelocityTabListEntry> entries = new ConcurrentHashMap<UUID, KeyedVelocityTabListEntry>();

    public KeyedVelocityTabList(ConnectedPlayer player, ProxyServer proxyServer) {
        this.player = player;
        this.proxyServer = proxyServer;
        this.connection = player.getConnection();
    }

    @Override
    @Deprecated
    public void setHeaderAndFooter(Component header, Component footer) {
        Preconditions.checkNotNull(header, "header");
        Preconditions.checkNotNull(footer, "footer");
        this.player.sendPlayerListHeaderAndFooter(header, footer);
    }

    @Override
    public void clearHeaderAndFooter() {
        this.player.clearPlayerListHeaderAndFooter();
    }

    @Override
    public void addEntry(TabListEntry entry) {
        Preconditions.checkNotNull(entry, "entry");
        Preconditions.checkArgument(entry.getTabList().equals(this), "The provided entry was not created by this tab list");
        Preconditions.checkArgument(!this.entries.containsKey(entry.getProfile().getId()), "this TabList already contains an entry with the same uuid");
        Preconditions.checkArgument(entry instanceof KeyedVelocityTabListEntry, "Not a Velocity tab list entry");
        LegacyPlayerListItem.Item packetItem = LegacyPlayerListItem.Item.from(entry);
        this.connection.write(new LegacyPlayerListItem(0, Collections.singletonList(packetItem)));
        this.entries.put(entry.getProfile().getId(), (KeyedVelocityTabListEntry)entry);
    }

    @Override
    public Optional<TabListEntry> removeEntry(UUID uuid) {
        Preconditions.checkNotNull(uuid, "uuid");
        TabListEntry entry = this.entries.remove(uuid);
        if (entry != null) {
            LegacyPlayerListItem.Item packetItem = LegacyPlayerListItem.Item.from(entry);
            this.connection.write(new LegacyPlayerListItem(4, Collections.singletonList(packetItem)));
        }
        return Optional.ofNullable(entry);
    }

    @Override
    public boolean containsEntry(UUID uuid) {
        Preconditions.checkNotNull(uuid, "uuid");
        return this.entries.containsKey(uuid);
    }

    @Override
    public Optional<TabListEntry> getEntry(UUID uuid) {
        return Optional.ofNullable((TabListEntry)this.entries.get(uuid));
    }

    @Override
    public void clearAll() {
        Collection<KeyedVelocityTabListEntry> listEntries = this.entries.values();
        if (listEntries.isEmpty()) {
            return;
        }
        ArrayList<LegacyPlayerListItem.Item> items = new ArrayList<LegacyPlayerListItem.Item>(listEntries.size());
        for (TabListEntry tabListEntry : listEntries) {
            items.add(LegacyPlayerListItem.Item.from(tabListEntry));
        }
        this.clearAllSilent();
        this.connection.delayedWrite(new LegacyPlayerListItem(4, items));
    }

    @Override
    public void clearAllSilent() {
        this.entries.clear();
    }

    @Override
    public Collection<TabListEntry> getEntries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    @Override
    public TabListEntry buildEntry(GameProfile profile, @Nullable Component displayName, int latency, int gameMode, @Nullable IdentifiedKey key) {
        return new KeyedVelocityTabListEntry(this, profile, displayName, latency, gameMode, key);
    }

    @Override
    public TabListEntry buildEntry(GameProfile profile, @Nullable Component displayName, int latency, int gameMode, @Nullable ChatSession chatSession, boolean listed) {
        return new KeyedVelocityTabListEntry(this, profile, displayName, latency, gameMode, chatSession == null ? null : chatSession.getIdentifiedKey());
    }

    @Override
    public void processLegacy(LegacyPlayerListItem packet) {
        for (LegacyPlayerListItem.Item item : packet.getItems()) {
            UUID uuid = item.getUuid();
            assert (uuid != null) : "1.7 tab list entry given to modern tab list handler!";
            if (packet.getAction() != 0 && !this.entries.containsKey(uuid)) continue;
            switch (packet.getAction()) {
                case 0: {
                    String name = item.getName();
                    List<GameProfile.Property> properties = item.getProperties();
                    if (name == null || properties == null) {
                        throw new IllegalStateException("Got null game profile for ADD_PLAYER");
                    }
                    this.entries.putIfAbsent(item.getUuid(), (KeyedVelocityTabListEntry)TabListEntry.builder().tabList(this).profile(new GameProfile(uuid, name, properties)).displayName(item.getDisplayName()).latency(item.getLatency()).chatSession(new RemoteChatSession(null, item.getPlayerKey())).gameMode(item.getGameMode()).build());
                    break;
                }
                case 4: {
                    this.entries.remove(uuid);
                    break;
                }
                case 3: {
                    KeyedVelocityTabListEntry entry = this.entries.get(uuid);
                    if (entry == null) break;
                    entry.setDisplayNameInternal(item.getDisplayName());
                    break;
                }
                case 2: {
                    KeyedVelocityTabListEntry entry = this.entries.get(uuid);
                    if (entry == null) break;
                    entry.setLatencyInternal(item.getLatency());
                    break;
                }
                case 1: {
                    KeyedVelocityTabListEntry entry = this.entries.get(uuid);
                    if (entry == null) break;
                    entry.setGameModeInternal(item.getGameMode());
                    break;
                }
            }
        }
    }

    void updateEntry(int action, TabListEntry entry) {
        if (this.entries.containsKey(entry.getProfile().getId())) {
            LegacyPlayerListItem.Item packetItem = LegacyPlayerListItem.Item.from(entry);
            IdentifiedKey selectedKey = packetItem.getPlayerKey();
            Optional<Player> existing = this.proxyServer.getPlayer(entry.getProfile().getId());
            if (existing.isPresent()) {
                selectedKey = existing.get().getIdentifiedKey();
            }
            if (selectedKey != null && selectedKey.getKeyRevision().getApplicableTo().contains((Object)this.connection.getProtocolVersion()) && Objects.equals(selectedKey.getSignatureHolder(), entry.getProfile().getId())) {
                packetItem.setPlayerKey(selectedKey);
            } else {
                packetItem.setPlayerKey(null);
            }
            this.connection.write(new LegacyPlayerListItem(action, Collections.singletonList(packetItem)));
        }
    }
}

