/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.tablist;

import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.player.TabListEntry;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.LegacyPlayerListItem;
import com.velocitypowered.proxy.tablist.KeyedVelocityTabList;
import com.velocitypowered.proxy.tablist.KeyedVelocityTabListEntry;
import com.velocitypowered.proxy.tablist.VelocityTabListEntryLegacy;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VelocityTabListLegacy
extends KeyedVelocityTabList {
    private final Map<String, UUID> nameMapping = new ConcurrentHashMap<String, UUID>();

    public VelocityTabListLegacy(ConnectedPlayer player, ProxyServer proxyServer) {
        super(player, proxyServer);
    }

    @Override
    @Deprecated
    public void setHeaderAndFooter(Component header, Component footer) {
    }

    @Override
    public void clearHeaderAndFooter() {
    }

    @Override
    public void addEntry(TabListEntry entry) {
        super.addEntry(entry);
        this.nameMapping.put(entry.getProfile().getName(), entry.getProfile().getId());
    }

    @Override
    public Optional<TabListEntry> removeEntry(UUID uuid) {
        Optional<TabListEntry> entry = super.removeEntry(uuid);
        entry.map(TabListEntry::getProfile).map(GameProfile::getName).ifPresent(this.nameMapping::remove);
        return entry;
    }

    @Override
    public void clearAll() {
        for (TabListEntry value : this.entries.values()) {
            this.connection.delayedWrite(new LegacyPlayerListItem(4, Collections.singletonList(LegacyPlayerListItem.Item.from(value))));
        }
        this.clearAllSilent();
    }

    @Override
    public void clearAllSilent() {
        this.entries.clear();
        this.nameMapping.clear();
    }

    @Override
    public void processLegacy(LegacyPlayerListItem packet) {
        LegacyPlayerListItem.Item item = packet.getItems().get(0);
        switch (packet.getAction()) {
            case 0: {
                if (this.nameMapping.containsKey(item.getName())) {
                    KeyedVelocityTabListEntry entry = (KeyedVelocityTabListEntry)this.entries.get(this.nameMapping.get(item.getName()));
                    if (entry == null) break;
                    entry.setLatencyInternal(item.getLatency());
                    break;
                }
                UUID uuid = UUID.randomUUID();
                this.nameMapping.put(item.getName(), uuid);
                this.entries.put(uuid, (KeyedVelocityTabListEntry)TabListEntry.builder().tabList(this).profile(new GameProfile(uuid, item.getName(), ImmutableList.of())).latency(item.getLatency()).build());
                break;
            }
            case 4: {
                UUID removedUuid = this.nameMapping.remove(item.getName());
                if (removedUuid == null) break;
                this.entries.remove(removedUuid);
                break;
            }
        }
    }

    @Override
    void updateEntry(int action, TabListEntry entry) {
        if (this.entries.containsKey(entry.getProfile().getId())) {
            switch (action) {
                case 2: 
                case 3: {
                    this.connection.write(new LegacyPlayerListItem(0, Collections.singletonList(LegacyPlayerListItem.Item.from(entry))));
                    break;
                }
            }
        }
    }

    @Override
    public TabListEntry buildEntry(GameProfile profile, @Nullable Component displayName, int latency, int gameMode) {
        return new VelocityTabListEntryLegacy(this, profile, displayName, latency, gameMode);
    }
}

