/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.proxy.server;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.util.Favicon;
import com.velocitypowered.api.util.ModInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ServerPing {
    private final Version version;
    private final @Nullable Players players;
    private final Component description;
    private final @Nullable Favicon favicon;
    private final @Nullable ModInfo modinfo;

    public ServerPing(Version version, @Nullable Players players, Component description, @Nullable Favicon favicon) {
        this(version, players, description, favicon, ModInfo.DEFAULT);
    }

    public ServerPing(Version version, @Nullable Players players, Component description, @Nullable Favicon favicon, @Nullable ModInfo modinfo) {
        this.version = Preconditions.checkNotNull(version, "version");
        this.players = players;
        this.description = Preconditions.checkNotNull(description, "description");
        this.favicon = favicon;
        this.modinfo = modinfo;
    }

    public Version getVersion() {
        return this.version;
    }

    public Optional<Players> getPlayers() {
        return Optional.ofNullable(this.players);
    }

    public Component getDescriptionComponent() {
        return this.description;
    }

    public Optional<Favicon> getFavicon() {
        return Optional.ofNullable(this.favicon);
    }

    public Optional<ModInfo> getModinfo() {
        return Optional.ofNullable(this.modinfo);
    }

    public String toString() {
        return "ServerPing{version=" + this.version + ", players=" + this.players + ", description=" + this.description + ", favicon=" + this.favicon + ", modinfo=" + this.modinfo + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerPing ping = (ServerPing)o;
        return Objects.equals(this.version, ping.version) && Objects.equals(this.players, ping.players) && Objects.equals(this.description, ping.description) && Objects.equals(this.favicon, ping.favicon) && Objects.equals(this.modinfo, ping.modinfo);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.players, this.description, this.favicon, this.modinfo);
    }

    public Builder asBuilder() {
        Builder builder = new Builder();
        builder.version = this.version;
        if (this.players != null) {
            builder.onlinePlayers = this.players.online;
            builder.maximumPlayers = this.players.max;
            builder.samplePlayers.addAll(this.players.getSample());
        } else {
            builder.nullOutPlayers = true;
        }
        builder.description = this.description;
        builder.favicon = this.favicon;
        boolean bl = builder.nullOutModinfo = this.modinfo == null;
        if (this.modinfo != null) {
            builder.modType = this.modinfo.getType();
            builder.mods.addAll(this.modinfo.getMods());
        }
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Version {
        private final int protocol;
        private final String name;

        public Version(int protocol, String name) {
            this.protocol = protocol;
            this.name = Preconditions.checkNotNull(name, "name");
        }

        public int getProtocol() {
            return this.protocol;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "Version{protocol=" + this.protocol + ", name='" + this.name + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Version version = (Version)o;
            return this.protocol == version.protocol && Objects.equals(this.name, version.name);
        }

        public int hashCode() {
            return Objects.hash(this.protocol, this.name);
        }
    }

    public static final class Players {
        private final int online;
        private final int max;
        private final List<SamplePlayer> sample;

        public Players(int online, int max, List<SamplePlayer> sample) {
            this.online = online;
            this.max = max;
            this.sample = ImmutableList.copyOf(sample);
        }

        public int getOnline() {
            return this.online;
        }

        public int getMax() {
            return this.max;
        }

        public List<SamplePlayer> getSample() {
            return this.sample == null ? ImmutableList.of() : this.sample;
        }

        public String toString() {
            return "Players{online=" + this.online + ", max=" + this.max + ", sample=" + this.sample + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Players players = (Players)o;
            return this.online == players.online && this.max == players.max && Objects.equals(this.sample, players.sample);
        }

        public int hashCode() {
            return Objects.hash(this.online, this.max, this.sample);
        }
    }

    public static final class Builder {
        private Version version = new Version(0, "Unknown");
        private int onlinePlayers;
        private int maximumPlayers;
        private final List<SamplePlayer> samplePlayers = new ArrayList<SamplePlayer>();
        private String modType = "FML";
        private final List<ModInfo.Mod> mods = new ArrayList<ModInfo.Mod>();
        private Component description;
        private @Nullable Favicon favicon;
        private boolean nullOutPlayers;
        private boolean nullOutModinfo;

        private Builder() {
        }

        public Builder version(Version version) {
            this.version = Preconditions.checkNotNull(version, "version");
            return this;
        }

        public Builder onlinePlayers(int onlinePlayers) {
            this.onlinePlayers = onlinePlayers;
            return this;
        }

        public Builder maximumPlayers(int maximumPlayers) {
            this.maximumPlayers = maximumPlayers;
            return this;
        }

        public Builder samplePlayers(SamplePlayer ... players) {
            this.samplePlayers.addAll(Arrays.asList(players));
            return this;
        }

        public Builder modType(String modType) {
            this.modType = Preconditions.checkNotNull(modType, "modType");
            return this;
        }

        public Builder mods(ModInfo.Mod ... mods) {
            this.mods.addAll(Arrays.asList(mods));
            return this;
        }

        public Builder mods(ModInfo mods) {
            Preconditions.checkNotNull(mods, "mods");
            this.modType = mods.getType();
            this.mods.clear();
            this.mods.addAll(mods.getMods());
            return this;
        }

        public Builder clearMods() {
            this.mods.clear();
            return this;
        }

        public Builder clearSamplePlayers() {
            this.samplePlayers.clear();
            return this;
        }

        public Builder notModCompatible() {
            this.nullOutModinfo = true;
            return this;
        }

        public Builder nullPlayers() {
            this.nullOutPlayers = true;
            return this;
        }

        public Builder description(Component description) {
            this.description = Preconditions.checkNotNull(description, "description");
            return this;
        }

        public Builder favicon(Favicon favicon) {
            this.favicon = Preconditions.checkNotNull(favicon, "favicon");
            return this;
        }

        public Builder clearFavicon() {
            this.favicon = null;
            return this;
        }

        public ServerPing build() {
            if (this.version == null) {
                throw new IllegalStateException("version not specified");
            }
            if (this.description == null) {
                throw new IllegalStateException("no server description supplied");
            }
            return new ServerPing(this.version, this.nullOutPlayers ? null : new Players(this.onlinePlayers, this.maximumPlayers, this.samplePlayers), this.description, this.favicon, this.nullOutModinfo ? null : new ModInfo(this.modType, this.mods));
        }

        public Version getVersion() {
            return this.version;
        }

        public int getOnlinePlayers() {
            return this.onlinePlayers;
        }

        public int getMaximumPlayers() {
            return this.maximumPlayers;
        }

        public List<SamplePlayer> getSamplePlayers() {
            return this.samplePlayers;
        }

        public Optional<Component> getDescriptionComponent() {
            return Optional.ofNullable(this.description);
        }

        public Optional<Favicon> getFavicon() {
            return Optional.ofNullable(this.favicon);
        }

        public String getModType() {
            return this.modType;
        }

        public List<ModInfo.Mod> getMods() {
            return this.mods;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("version", this.version).add("onlinePlayers", this.onlinePlayers).add("maximumPlayers", this.maximumPlayers).add("samplePlayers", this.samplePlayers).add("modType", this.modType).add("mods", this.mods).add("description", this.description).add("favicon", this.favicon).add("nullOutPlayers", this.nullOutPlayers).add("nullOutModinfo", this.nullOutModinfo).toString();
        }
    }

    public static final class SamplePlayer {
        private final String name;
        private final UUID id;

        public SamplePlayer(String name, UUID id) {
            this.name = name;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public UUID getId() {
            return this.id;
        }

        public String toString() {
            return "SamplePlayer{name='" + this.name + "', id=" + this.id + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SamplePlayer that = (SamplePlayer)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.id);
        }
    }
}

