/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.velocitypowered.api.network.ProtocolState;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.LoginPhaseConnection;
import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.api.proxy.crypto.KeyIdentifiable;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.client.InitialInboundConnection;
import com.velocitypowered.proxy.protocol.packet.LoginPluginMessagePacket;
import com.velocitypowered.proxy.protocol.packet.LoginPluginResponsePacket;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import space.vectrix.flare.fastutil.Int2ObjectSyncMap;

public class LoginInboundConnection
implements LoginPhaseConnection,
KeyIdentifiable {
    private static final AtomicIntegerFieldUpdater<LoginInboundConnection> SEQUENCE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(LoginInboundConnection.class, "sequenceCounter");
    private final InitialInboundConnection delegate;
    private final Int2ObjectMap<LoginPhaseConnection.MessageConsumer> outstandingResponses;
    private volatile int sequenceCounter;
    private final Queue<LoginPluginMessagePacket> loginMessagesToSend;
    private volatile Runnable onAllMessagesHandled;
    private volatile boolean loginEventFired;
    private @MonotonicNonNull IdentifiedKey playerKey;

    LoginInboundConnection(InitialInboundConnection delegate) {
        this.delegate = delegate;
        this.outstandingResponses = Int2ObjectSyncMap.hashmap();
        this.loginMessagesToSend = new ConcurrentLinkedQueue<LoginPluginMessagePacket>();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.delegate.getRemoteAddress();
    }

    @Override
    public Optional<InetSocketAddress> getVirtualHost() {
        return this.delegate.getVirtualHost();
    }

    @Override
    public boolean isActive() {
        return this.delegate.isActive();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.delegate.getProtocolVersion();
    }

    @Override
    public void sendLoginPluginMessage(ChannelIdentifier identifier, byte[] contents, LoginPhaseConnection.MessageConsumer consumer) {
        if (identifier == null) {
            throw new NullPointerException("identifier");
        }
        if (contents == null) {
            throw new NullPointerException("contents");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer");
        }
        if (this.delegate.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_13)) {
            throw new IllegalStateException("Login plugin messages can only be sent to clients running Minecraft 1.13 and above");
        }
        int id = SEQUENCE_UPDATER.incrementAndGet(this);
        this.outstandingResponses.put(id, consumer);
        LoginPluginMessagePacket message = new LoginPluginMessagePacket(id, identifier.getId(), Unpooled.wrappedBuffer(contents));
        if (!this.loginEventFired) {
            this.loginMessagesToSend.add(message);
        } else {
            this.delegate.getConnection().write(message);
        }
    }

    public void disconnect(Component reason) {
        this.delegate.disconnect(reason);
        this.cleanup();
    }

    void cleanup() {
        this.loginMessagesToSend.clear();
        this.outstandingResponses.clear();
        this.onAllMessagesHandled = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleLoginPluginResponse(LoginPluginResponsePacket response) {
        LoginPhaseConnection.MessageConsumer consumer = (LoginPhaseConnection.MessageConsumer)this.outstandingResponses.remove(response.getId());
        if (consumer != null) {
            try {
                consumer.onMessageResponse(response.isSuccess() ? ByteBufUtil.getBytes(response.content()) : null);
            }
            finally {
                Runnable onAllMessagesHandled = this.onAllMessagesHandled;
                if (this.outstandingResponses.isEmpty() && onAllMessagesHandled != null) {
                    onAllMessagesHandled.run();
                }
            }
        }
    }

    void loginEventFired(Runnable onAllMessagesHandled) {
        this.loginEventFired = true;
        this.onAllMessagesHandled = onAllMessagesHandled;
        if (!this.loginMessagesToSend.isEmpty()) {
            LoginPluginMessagePacket message;
            while ((message = this.loginMessagesToSend.poll()) != null) {
                this.delegate.getConnection().delayedWrite(message);
            }
            this.delegate.getConnection().flush();
        } else {
            onAllMessagesHandled.run();
        }
    }

    MinecraftConnection delegatedConnection() {
        return this.delegate.getConnection();
    }

    public void setPlayerKey(IdentifiedKey playerKey) {
        this.playerKey = playerKey;
    }

    @Override
    public IdentifiedKey getIdentifiedKey() {
        return this.playerKey;
    }

    @Override
    public ProtocolState getProtocolState() {
        return this.delegate.getProtocolState();
    }
}

