/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.config;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;

public class ClientboundServerLinksPacket
implements MinecraftPacket {
    private List<ServerLink> serverLinks;

    public ClientboundServerLinksPacket() {
    }

    public ClientboundServerLinksPacket(List<ServerLink> serverLinks) {
        this.serverLinks = serverLinks;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        int linksCount = ProtocolUtils.readVarInt(buf);
        this.serverLinks = new ArrayList<ServerLink>(linksCount);
        for (int i = 0; i < linksCount; ++i) {
            this.serverLinks.add(ServerLink.read(buf, version));
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ProtocolUtils.writeVarInt(buf, this.serverLinks.size());
        for (ServerLink serverLink : this.serverLinks) {
            serverLink.write(buf);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    public List<ServerLink> getServerLinks() {
        return this.serverLinks;
    }

    public record ServerLink(int id, ComponentHolder displayName, String url) {
        public ServerLink(com.velocitypowered.api.util.ServerLink link, ProtocolVersion protocolVersion) {
            this(link.getBuiltInType().map(Enum::ordinal).orElse(-1), link.getCustomLabel().map(c -> new ComponentHolder(protocolVersion, (Component)c)).orElse(null), link.getUrl().toString());
        }

        private static ServerLink read(ByteBuf buf, ProtocolVersion version) {
            if (buf.readBoolean()) {
                return new ServerLink(ProtocolUtils.readVarInt(buf), null, ProtocolUtils.readString(buf));
            }
            return new ServerLink(-1, ComponentHolder.read(buf, version), ProtocolUtils.readString(buf));
        }

        private void write(ByteBuf buf) {
            if (this.id >= 0) {
                buf.writeBoolean(true);
                ProtocolUtils.writeVarInt(buf, this.id);
            } else {
                buf.writeBoolean(false);
                this.displayName.write(buf);
            }
            ProtocolUtils.writeString(buf, this.url);
        }
    }
}

