/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.util;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.ChannelRegistrar;
import com.velocitypowered.api.proxy.messages.LegacyChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.proxy.protocol.util.PluginMessageUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VelocityChannelRegistrar
implements ChannelRegistrar {
    private final Map<String, ChannelIdentifier> identifierMap = new ConcurrentHashMap<String, ChannelIdentifier>();

    @Override
    public void register(ChannelIdentifier ... identifiers) {
        for (ChannelIdentifier identifier : identifiers) {
            Preconditions.checkArgument(identifier instanceof LegacyChannelIdentifier || identifier instanceof MinecraftChannelIdentifier, "identifier is unknown");
        }
        for (ChannelIdentifier identifier : identifiers) {
            if (identifier instanceof MinecraftChannelIdentifier) {
                this.identifierMap.put(identifier.getId(), identifier);
                continue;
            }
            String rewritten = PluginMessageUtil.transformLegacyToModernChannel(identifier.getId());
            this.identifierMap.put(identifier.getId(), identifier);
            this.identifierMap.put(rewritten, identifier);
        }
    }

    @Override
    public void unregister(ChannelIdentifier ... identifiers) {
        for (ChannelIdentifier identifier : identifiers) {
            Preconditions.checkArgument(identifier instanceof LegacyChannelIdentifier || identifier instanceof MinecraftChannelIdentifier, "identifier is unknown");
        }
        for (ChannelIdentifier identifier : identifiers) {
            if (identifier instanceof MinecraftChannelIdentifier) {
                this.identifierMap.remove(identifier.getId());
                continue;
            }
            String rewritten = PluginMessageUtil.transformLegacyToModernChannel(identifier.getId());
            this.identifierMap.remove(identifier.getId());
            this.identifierMap.remove(rewritten);
        }
    }

    public Collection<String> getLegacyChannelIds() {
        HashSet<String> ids = new HashSet<String>();
        for (ChannelIdentifier value : this.identifierMap.values()) {
            ids.add(value.getId());
        }
        return ids;
    }

    public Collection<String> getModernChannelIds() {
        HashSet<String> ids = new HashSet<String>();
        for (ChannelIdentifier value : this.identifierMap.values()) {
            if (value instanceof MinecraftChannelIdentifier) {
                ids.add(value.getId());
                continue;
            }
            ids.add(PluginMessageUtil.transformLegacyToModernChannel(value.getId()));
        }
        return ids;
    }

    public @Nullable ChannelIdentifier getFromId(String id) {
        return this.identifierMap.get(id);
    }

    public Collection<String> getChannelsForProtocol(ProtocolVersion protocolVersion) {
        if (protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_13)) {
            return this.getModernChannelIds();
        }
        return this.getLegacyChannelIds();
    }
}

