/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.adventure;

import com.google.common.collect.MapMaker;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.BossBarPacket;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.bossbar.BossBarImplementation;
import net.kyori.adventure.text.Component;

public final class VelocityBossBarImplementation
implements BossBar.Listener,
BossBarImplementation {
    private final Set<ConnectedPlayer> viewers = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private final UUID id = UUID.randomUUID();
    private final BossBar bar;

    public static VelocityBossBarImplementation get(BossBar bar) {
        return BossBarImplementation.get(bar, VelocityBossBarImplementation.class);
    }

    VelocityBossBarImplementation(BossBar bar) {
        this.bar = bar;
    }

    public boolean viewerAdd(ConnectedPlayer viewer) {
        if (this.viewers.add(viewer)) {
            ComponentHolder name = new ComponentHolder(viewer.getProtocolVersion(), viewer.translateMessage(this.bar.name()));
            viewer.getConnection().write(BossBarPacket.createAddPacket(this.id, this.bar, name));
            return true;
        }
        return false;
    }

    public boolean viewerRemove(ConnectedPlayer viewer) {
        if (this.viewers.remove(viewer)) {
            viewer.getConnection().write(BossBarPacket.createRemovePacket(this.id, this.bar));
            return true;
        }
        return false;
    }

    public void viewerDisconnected(ConnectedPlayer viewer) {
        this.viewers.remove(viewer);
    }

    @Override
    public void bossBarNameChanged(BossBar bar, Component oldName, Component newName) {
        for (ConnectedPlayer viewer : this.viewers) {
            Component translated = viewer.translateMessage(newName);
            BossBarPacket packet = BossBarPacket.createUpdateNamePacket(this.id, this.bar, new ComponentHolder(viewer.getProtocolVersion(), translated));
            viewer.getConnection().write(packet);
        }
    }

    @Override
    public void bossBarProgressChanged(BossBar bar, float oldProgress, float newProgress) {
        BossBarPacket packet = BossBarPacket.createUpdateProgressPacket(this.id, this.bar);
        for (ConnectedPlayer viewer : this.viewers) {
            viewer.getConnection().write(packet);
        }
    }

    @Override
    public void bossBarColorChanged(BossBar bar, BossBar.Color oldColor, BossBar.Color newColor) {
        BossBarPacket packet = BossBarPacket.createUpdateStylePacket(this.id, this.bar);
        for (ConnectedPlayer viewer : this.viewers) {
            viewer.getConnection().write(packet);
        }
    }

    @Override
    public void bossBarOverlayChanged(BossBar bar, BossBar.Overlay oldOverlay, BossBar.Overlay newOverlay) {
        BossBarPacket packet = BossBarPacket.createUpdateStylePacket(this.id, this.bar);
        for (ConnectedPlayer viewer : this.viewers) {
            viewer.getConnection().write(packet);
        }
    }

    @Override
    public void bossBarFlagsChanged(BossBar bar, Set<BossBar.Flag> flagsAdded, Set<BossBar.Flag> flagsRemoved) {
        BossBarPacket packet = BossBarPacket.createUpdatePropertiesPacket(this.id, this.bar);
        for (ConnectedPlayer viewer : this.viewers) {
            viewer.getConnection().write(packet);
        }
    }
}

