/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.backend;

import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.connection.PreTransferEvent;
import com.velocitypowered.api.event.player.CookieRequestEvent;
import com.velocitypowered.api.event.player.CookieStoreEvent;
import com.velocitypowered.api.event.player.PlayerResourcePackStatusEvent;
import com.velocitypowered.api.event.player.ServerResourcePackRemoveEvent;
import com.velocitypowered.api.event.player.ServerResourcePackSendEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.TransitionSessionHandler;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ClientConfigSessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.player.resourcepack.VelocityResourcePackInfo;
import com.velocitypowered.proxy.connection.player.resourcepack.handler.ResourcePackHandler;
import com.velocitypowered.proxy.connection.util.ConnectionMessages;
import com.velocitypowered.proxy.connection.util.ConnectionRequestResults;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.netty.MinecraftDecoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftVarintFrameDecoder;
import com.velocitypowered.proxy.protocol.packet.ClientboundCookieRequestPacket;
import com.velocitypowered.proxy.protocol.packet.ClientboundStoreCookiePacket;
import com.velocitypowered.proxy.protocol.packet.DisconnectPacket;
import com.velocitypowered.proxy.protocol.packet.KeepAlivePacket;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import com.velocitypowered.proxy.protocol.packet.RemoveResourcePackPacket;
import com.velocitypowered.proxy.protocol.packet.ResourcePackRequestPacket;
import com.velocitypowered.proxy.protocol.packet.ResourcePackResponsePacket;
import com.velocitypowered.proxy.protocol.packet.TransferPacket;
import com.velocitypowered.proxy.protocol.packet.config.ClientboundCustomReportDetailsPacket;
import com.velocitypowered.proxy.protocol.packet.config.ClientboundServerLinksPacket;
import com.velocitypowered.proxy.protocol.packet.config.FinishedUpdatePacket;
import com.velocitypowered.proxy.protocol.packet.config.RegistrySyncPacket;
import com.velocitypowered.proxy.protocol.packet.config.StartUpdatePacket;
import com.velocitypowered.proxy.protocol.packet.config.TagsUpdatePacket;
import com.velocitypowered.proxy.protocol.util.PluginMessageUtil;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.kyori.adventure.key.Key;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigSessionHandler
implements MinecraftSessionHandler {
    private static final Logger logger = LogManager.getLogger(ConfigSessionHandler.class);
    private final VelocityServer server;
    private final VelocityServerConnection serverConn;
    private final CompletableFuture<ConnectionRequestResults.Impl> resultFuture;
    private ResourcePackInfo resourcePackToApply;
    private State state;

    ConfigSessionHandler(VelocityServer server, VelocityServerConnection serverConn, CompletableFuture<ConnectionRequestResults.Impl> resultFuture) {
        this.server = server;
        this.serverConn = serverConn;
        this.resultFuture = resultFuture;
        this.state = State.START;
    }

    @Override
    public void activated() {
        ConnectedPlayer player = this.serverConn.getPlayer();
        if (player.getProtocolVersion() == ProtocolVersion.MINECRAFT_1_20_2) {
            this.resourcePackToApply = player.resourcePackHandler().getFirstAppliedPack();
            player.resourcePackHandler().clearAppliedResourcePacks();
        }
    }

    @Override
    public boolean beforeHandle() {
        if (!this.serverConn.isActive()) {
            this.serverConn.disconnect();
            return true;
        }
        return false;
    }

    @Override
    public boolean handle(StartUpdatePacket packet) {
        this.serverConn.ensureConnected().write(packet);
        return true;
    }

    @Override
    public boolean handle(TagsUpdatePacket packet) {
        this.serverConn.getPlayer().getConnection().write(packet);
        return true;
    }

    @Override
    public boolean handle(ClientboundCustomReportDetailsPacket packet) {
        this.serverConn.getPlayer().getConnection().write(packet);
        return true;
    }

    @Override
    public boolean handle(ClientboundServerLinksPacket packet) {
        this.serverConn.getPlayer().getConnection().write(packet);
        return true;
    }

    @Override
    public boolean handle(KeepAlivePacket packet) {
        this.serverConn.getPendingPings().put(packet.getRandomId(), System.nanoTime());
        this.serverConn.getPlayer().getConnection().write(packet);
        return true;
    }

    @Override
    public boolean handle(ResourcePackRequestPacket packet) {
        MinecraftConnection playerConnection = this.serverConn.getPlayer().getConnection();
        VelocityResourcePackInfo resourcePackInfo = packet.toServerPromptedPack();
        ServerResourcePackSendEvent event = new ServerResourcePackSendEvent(resourcePackInfo, this.serverConn);
        ((CompletableFuture)this.server.getEventManager().fire(event).thenAcceptAsync(serverResourcePackSendEvent -> {
            if (playerConnection.isClosed()) {
                return;
            }
            if (serverResourcePackSendEvent.getResult().isAllowed()) {
                ResourcePackInfo toSend = serverResourcePackSendEvent.getProvidedResourcePack();
                boolean modifiedPack = false;
                if (toSend != serverResourcePackSendEvent.getReceivedResourcePack()) {
                    ((VelocityResourcePackInfo)toSend).setOriginalOrigin(ResourcePackInfo.Origin.DOWNSTREAM_SERVER);
                    modifiedPack = true;
                }
                if (this.serverConn.getPlayer().resourcePackHandler().hasPackAppliedByHash(toSend.getHash())) {
                    if (this.serverConn.getConnection() != null) {
                        this.serverConn.getConnection().write(new ResourcePackResponsePacket(packet.getId(), packet.getHash(), PlayerResourcePackStatusEvent.Status.ACCEPTED));
                        this.serverConn.getConnection().write(new ResourcePackResponsePacket(packet.getId(), packet.getHash(), PlayerResourcePackStatusEvent.Status.DOWNLOADED));
                        this.serverConn.getConnection().write(new ResourcePackResponsePacket(packet.getId(), packet.getHash(), PlayerResourcePackStatusEvent.Status.SUCCESSFUL));
                    }
                    if (modifiedPack) {
                        logger.warn("A plugin has tried to modify a ResourcePack provided by the backend server with a ResourcePack already applied, the applying of the resource pack will be skipped.");
                    }
                } else {
                    this.resourcePackToApply = null;
                    this.serverConn.getPlayer().resourcePackHandler().queueResourcePack(toSend);
                }
            } else if (this.serverConn.getConnection() != null) {
                this.serverConn.getConnection().write(new ResourcePackResponsePacket(packet.getId(), packet.getHash(), PlayerResourcePackStatusEvent.Status.DECLINED));
            }
        }, (Executor)playerConnection.eventLoop())).exceptionally(ex -> {
            if (this.serverConn.getConnection() != null) {
                this.serverConn.getConnection().write(new ResourcePackResponsePacket(packet.getId(), packet.getHash(), PlayerResourcePackStatusEvent.Status.DECLINED));
            }
            logger.error("Exception while handling resource pack send for {}", (Object)playerConnection, ex);
            return null;
        });
        return true;
    }

    @Override
    public boolean handle(RemoveResourcePackPacket packet) {
        MinecraftConnection playerConnection = this.serverConn.getPlayer().getConnection();
        ServerResourcePackRemoveEvent event = new ServerResourcePackRemoveEvent(packet.getId(), this.serverConn);
        ((CompletableFuture)this.server.getEventManager().fire(event).thenAcceptAsync(serverResourcePackRemoveEvent -> {
            if (playerConnection.isClosed()) {
                return;
            }
            if (serverResourcePackRemoveEvent.getResult().isAllowed()) {
                ConnectedPlayer player = this.serverConn.getPlayer();
                ResourcePackHandler handler = player.resourcePackHandler();
                if (packet.getId() != null) {
                    handler.remove(packet.getId());
                } else {
                    handler.clearAppliedResourcePacks();
                }
                playerConnection.write(packet);
            }
        }, (Executor)playerConnection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception while handling resource pack remove for {}", (Object)playerConnection, ex);
            return null;
        });
        return true;
    }

    @Override
    public boolean handle(FinishedUpdatePacket packet) {
        MinecraftConnection smc = this.serverConn.ensureConnected();
        ConnectedPlayer player = this.serverConn.getPlayer();
        ClientConfigSessionHandler configHandler = (ClientConfigSessionHandler)player.getConnection().getActiveSessionHandler();
        smc.getChannel().pipeline().get(MinecraftVarintFrameDecoder.class).setState(StateRegistry.PLAY);
        smc.getChannel().pipeline().get(MinecraftDecoder.class).setState(StateRegistry.PLAY);
        configHandler.handleBackendFinishUpdate(this.serverConn).thenRunAsync(() -> {
            smc.write(FinishedUpdatePacket.INSTANCE);
            if (this.serverConn == player.getConnectedServer()) {
                smc.setActiveSessionHandler(StateRegistry.PLAY);
                player.sendPlayerListHeaderAndFooter(player.getPlayerListHeader(), player.getPlayerListFooter());
                player.getTabList().clearAllSilent();
            } else {
                smc.setActiveSessionHandler(StateRegistry.PLAY, new TransitionSessionHandler(this.server, this.serverConn, this.resultFuture));
            }
            if (player.resourcePackHandler().getFirstAppliedPack() == null && this.resourcePackToApply != null) {
                player.resourcePackHandler().queueResourcePack(this.resourcePackToApply);
            }
        }, smc.eventLoop());
        return true;
    }

    @Override
    public boolean handle(DisconnectPacket packet) {
        this.serverConn.disconnect();
        this.resultFuture.complete(ConnectionRequestResults.forDisconnect(packet, (RegisteredServer)this.serverConn.getServer()));
        return true;
    }

    @Override
    public boolean handle(PluginMessagePacket packet) {
        if (PluginMessageUtil.isMcBrand(packet)) {
            this.serverConn.getPlayer().getConnection().write(PluginMessageUtil.rewriteMinecraftBrand(packet, this.server.getVersion(), this.serverConn.getPlayer().getProtocolVersion()));
        } else {
            byte[] bytes = ByteBufUtil.getBytes(packet.content());
            ChannelIdentifier id = this.server.getChannelRegistrar().getFromId(packet.getChannel());
            if (id == null) {
                this.serverConn.getPlayer().getConnection().write(packet.retain());
                return true;
            }
            this.serverConn.getConnection().setAutoReading(false);
            ((CompletableFuture)this.server.getEventManager().fire(new PluginMessageEvent(this.serverConn, this.serverConn.getPlayer(), id, bytes)).thenAcceptAsync(pme -> {
                if (pme.getResult().isAllowed() && !this.serverConn.getPlayer().getConnection().isClosed()) {
                    this.serverConn.getPlayer().getConnection().write(new PluginMessagePacket(pme.getIdentifier().getId(), Unpooled.wrappedBuffer(bytes)));
                }
                this.serverConn.getConnection().setAutoReading(true);
            }, (Executor)this.serverConn.ensureConnected().eventLoop())).exceptionally(ex -> {
                logger.error("Exception while handling plugin message {}", (Object)packet, ex);
                return null;
            });
        }
        return true;
    }

    @Override
    public boolean handle(RegistrySyncPacket packet) {
        this.serverConn.getPlayer().getConnection().write(packet.retain());
        return true;
    }

    @Override
    public boolean handle(TransferPacket packet) {
        InetSocketAddress originalAddress = packet.address();
        if (originalAddress == null) {
            logger.error("Unexpected nullable address received in TransferPacket from Backend Server in Configuration State");
            return true;
        }
        this.server.getEventManager().fire(new PreTransferEvent(this.serverConn.getPlayer(), originalAddress)).thenAcceptAsync(event -> {
            if (event.getResult().isAllowed()) {
                InetSocketAddress resultedAddress = event.getResult().address();
                if (resultedAddress == null) {
                    resultedAddress = originalAddress;
                }
                this.serverConn.getPlayer().getConnection().write(new TransferPacket(resultedAddress.getHostName(), resultedAddress.getPort()));
            }
        }, (Executor)this.serverConn.ensureConnected().eventLoop());
        return true;
    }

    @Override
    public boolean handle(ClientboundStoreCookiePacket packet) {
        this.server.getEventManager().fire(new CookieStoreEvent(this.serverConn.getPlayer(), packet.getKey(), packet.getPayload())).thenAcceptAsync(event -> {
            if (event.getResult().isAllowed()) {
                Key resultedKey = event.getResult().getKey() == null ? event.getOriginalKey() : event.getResult().getKey();
                byte[] resultedData = event.getResult().getData() == null ? event.getOriginalData() : event.getResult().getData();
                this.serverConn.getPlayer().getConnection().write(new ClientboundStoreCookiePacket(resultedKey, resultedData));
            }
        }, (Executor)this.serverConn.ensureConnected().eventLoop());
        return true;
    }

    @Override
    public boolean handle(ClientboundCookieRequestPacket packet) {
        this.server.getEventManager().fire(new CookieRequestEvent(this.serverConn.getPlayer(), packet.getKey())).thenAcceptAsync(event -> {
            if (event.getResult().isAllowed()) {
                Key resultedKey = event.getResult().getKey() == null ? event.getOriginalKey() : event.getResult().getKey();
                this.serverConn.getPlayer().getConnection().write(new ClientboundCookieRequestPacket(resultedKey));
            }
        }, (Executor)this.serverConn.ensureConnected().eventLoop());
        return true;
    }

    @Override
    public void disconnected() {
        this.resultFuture.completeExceptionally(new IOException("Unexpectedly disconnected from remote server"));
    }

    @Override
    public void handleGeneric(MinecraftPacket packet) {
        this.serverConn.getPlayer().getConnection().write(packet);
    }

    private void switchFailure(Throwable cause) {
        logger.error("Unable to switch to new server {} for {}", (Object)this.serverConn.getServerInfo().getName(), (Object)this.serverConn.getPlayer().getUsername(), (Object)cause);
        this.serverConn.getPlayer().disconnect(ConnectionMessages.INTERNAL_SERVER_CONNECTION_ERROR);
        this.resultFuture.completeExceptionally(cause);
    }

    public static enum State {
        START,
        NEGOTIATING,
        PLUGIN_MESSAGE_INTERRUPT,
        RESOURCE_PACK_INTERRUPT,
        COMPLETE;

    }
}

