/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.player.resourcepack.handler;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.velocitypowered.api.event.player.PlayerResourcePackStatusEvent;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.player.resourcepack.ResourcePackResponseBundle;
import com.velocitypowered.proxy.connection.player.resourcepack.handler.ResourcePackHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModernResourcePackHandler
extends ResourcePackHandler {
    private final ListMultimap<UUID, ResourcePackInfo> outstandingResourcePacks = Multimaps.newListMultimap(new ConcurrentHashMap(), LinkedList::new);
    private final Map<UUID, ResourcePackInfo> pendingResourcePacks = new ConcurrentHashMap<UUID, ResourcePackInfo>();
    private final Map<UUID, ResourcePackInfo> appliedResourcePacks = new ConcurrentHashMap<UUID, ResourcePackInfo>();

    ModernResourcePackHandler(ConnectedPlayer player, VelocityServer server) {
        super(player, server);
    }

    @Override
    @Nullable
    public ResourcePackInfo getFirstAppliedPack() {
        if (this.appliedResourcePacks.isEmpty()) {
            return null;
        }
        return this.appliedResourcePacks.values().iterator().next();
    }

    @Override
    @Nullable
    public ResourcePackInfo getFirstPendingPack() {
        if (this.pendingResourcePacks.isEmpty()) {
            return null;
        }
        return this.pendingResourcePacks.values().iterator().next();
    }

    @Override
    @NotNull
    public Collection<ResourcePackInfo> getAppliedResourcePacks() {
        return List.copyOf(this.appliedResourcePacks.values());
    }

    @Override
    @NotNull
    public Collection<ResourcePackInfo> getPendingResourcePacks() {
        return List.copyOf(this.pendingResourcePacks.values());
    }

    @Override
    public void clearAppliedResourcePacks() {
        this.outstandingResourcePacks.clear();
        this.pendingResourcePacks.clear();
        this.appliedResourcePacks.clear();
    }

    @Override
    public boolean remove(@NotNull UUID uuid) {
        this.outstandingResourcePacks.removeAll(uuid);
        return this.appliedResourcePacks.remove(uuid) != null | this.pendingResourcePacks.remove(uuid) != null;
    }

    @Override
    public void queueResourcePack(@NotNull ResourcePackInfo info) {
        Collection outstandingResourcePacks = this.outstandingResourcePacks.get((Object)info.getId());
        outstandingResourcePacks.add(info);
        if (outstandingResourcePacks.size() == 1) {
            this.tickResourcePackQueue(((ResourcePackInfo)outstandingResourcePacks.get(0)).getId());
        }
    }

    @Override
    public void queueResourcePack(@NotNull ResourcePackRequest request) {
        if (request.packs().size() > 1) {
            this.player.getBundleHandler().bundlePackets(() -> super.queueResourcePack(request));
        } else {
            super.queueResourcePack(request);
        }
    }

    private void tickResourcePackQueue(@NotNull UUID uuid) {
        Collection outstandingResourcePacks = this.outstandingResourcePacks.get((Object)uuid);
        if (!outstandingResourcePacks.isEmpty()) {
            this.sendResourcePackRequestPacket((ResourcePackInfo)outstandingResourcePacks.get(0));
        }
    }

    @Override
    public boolean onResourcePackResponse(@NotNull ResourcePackResponseBundle bundle) {
        UUID uuid = bundle.uuid();
        Collection outstandingResourcePacks = this.outstandingResourcePacks.get((Object)uuid);
        boolean peek = bundle.status().isIntermediate();
        ResourcePackInfo queued = outstandingResourcePacks.isEmpty() ? null : (peek ? (ResourcePackInfo)outstandingResourcePacks.get(0) : (ResourcePackInfo)outstandingResourcePacks.remove(0));
        this.server.getEventManager().fire(new PlayerResourcePackStatusEvent(this.player, uuid, bundle.status(), queued)).thenAcceptAsync(event -> {
            if (event.getStatus() == PlayerResourcePackStatusEvent.Status.DECLINED && event.getPackInfo() != null && event.getPackInfo().getShouldForce() && !event.isOverwriteKick()) {
                this.player.disconnect(Component.translatable("multiplayer.requiredTexturePrompt.disconnect"));
            }
        });
        switch (bundle.status()) {
            case ACCEPTED: {
                if (queued == null) break;
                this.pendingResourcePacks.put(uuid, queued);
                break;
            }
            case SUCCESSFUL: {
                this.pendingResourcePacks.remove(uuid);
                if (queued != null) {
                    this.appliedResourcePacks.put(uuid, queued);
                    break;
                }
                ResourcePackInfo appliedPack = this.appliedResourcePacks.get(uuid);
                if (appliedPack == null) break;
                return this.handleResponseResult(appliedPack, bundle);
            }
            case DISCARDED: 
            case DECLINED: 
            case FAILED_RELOAD: 
            case FAILED_DOWNLOAD: 
            case INVALID_URL: {
                this.pendingResourcePacks.remove(uuid);
                this.appliedResourcePacks.remove(uuid);
                break;
            }
        }
        if (!peek) {
            this.player.getConnection().eventLoop().execute(() -> this.tickResourcePackQueue(uuid));
        }
        return this.handleResponseResult(queued, bundle);
    }

    @Override
    public boolean hasPackAppliedByHash(byte[] hash) {
        if (hash == null) {
            return false;
        }
        for (Map.Entry<UUID, ResourcePackInfo> appliedPack : this.appliedResourcePacks.entrySet()) {
            if (!Arrays.equals(appliedPack.getValue().getHash(), hash)) continue;
            return true;
        }
        return false;
    }
}

