/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol;

import com.google.common.collect.Iterables;
import com.velocitypowered.api.network.ProtocolState;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.AvailableCommandsPacket;
import com.velocitypowered.proxy.protocol.packet.BossBarPacket;
import com.velocitypowered.proxy.protocol.packet.BundleDelimiterPacket;
import com.velocitypowered.proxy.protocol.packet.ClientSettingsPacket;
import com.velocitypowered.proxy.protocol.packet.ClientboundCookieRequestPacket;
import com.velocitypowered.proxy.protocol.packet.ClientboundStoreCookiePacket;
import com.velocitypowered.proxy.protocol.packet.DialogClearPacket;
import com.velocitypowered.proxy.protocol.packet.DialogShowPacket;
import com.velocitypowered.proxy.protocol.packet.DisconnectPacket;
import com.velocitypowered.proxy.protocol.packet.EncryptionRequestPacket;
import com.velocitypowered.proxy.protocol.packet.EncryptionResponsePacket;
import com.velocitypowered.proxy.protocol.packet.HandshakePacket;
import com.velocitypowered.proxy.protocol.packet.HeaderAndFooterPacket;
import com.velocitypowered.proxy.protocol.packet.JoinGamePacket;
import com.velocitypowered.proxy.protocol.packet.KeepAlivePacket;
import com.velocitypowered.proxy.protocol.packet.LegacyPlayerListItemPacket;
import com.velocitypowered.proxy.protocol.packet.LoginAcknowledgedPacket;
import com.velocitypowered.proxy.protocol.packet.LoginPluginMessagePacket;
import com.velocitypowered.proxy.protocol.packet.LoginPluginResponsePacket;
import com.velocitypowered.proxy.protocol.packet.PingIdentifyPacket;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import com.velocitypowered.proxy.protocol.packet.RemovePlayerInfoPacket;
import com.velocitypowered.proxy.protocol.packet.RemoveResourcePackPacket;
import com.velocitypowered.proxy.protocol.packet.ResourcePackRequestPacket;
import com.velocitypowered.proxy.protocol.packet.ResourcePackResponsePacket;
import com.velocitypowered.proxy.protocol.packet.RespawnPacket;
import com.velocitypowered.proxy.protocol.packet.ServerDataPacket;
import com.velocitypowered.proxy.protocol.packet.ServerLoginPacket;
import com.velocitypowered.proxy.protocol.packet.ServerLoginSuccessPacket;
import com.velocitypowered.proxy.protocol.packet.ServerboundCookieResponsePacket;
import com.velocitypowered.proxy.protocol.packet.SetCompressionPacket;
import com.velocitypowered.proxy.protocol.packet.StatusPingPacket;
import com.velocitypowered.proxy.protocol.packet.StatusRequestPacket;
import com.velocitypowered.proxy.protocol.packet.StatusResponsePacket;
import com.velocitypowered.proxy.protocol.packet.TabCompleteRequestPacket;
import com.velocitypowered.proxy.protocol.packet.TabCompleteResponsePacket;
import com.velocitypowered.proxy.protocol.packet.TransferPacket;
import com.velocitypowered.proxy.protocol.packet.UpsertPlayerInfoPacket;
import com.velocitypowered.proxy.protocol.packet.chat.ChatAcknowledgementPacket;
import com.velocitypowered.proxy.protocol.packet.chat.PlayerChatCompletionPacket;
import com.velocitypowered.proxy.protocol.packet.chat.SystemChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedPlayerChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedPlayerCommandPacket;
import com.velocitypowered.proxy.protocol.packet.chat.legacy.LegacyChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerCommandPacket;
import com.velocitypowered.proxy.protocol.packet.chat.session.UnsignedPlayerCommandPacket;
import com.velocitypowered.proxy.protocol.packet.config.ActiveFeaturesPacket;
import com.velocitypowered.proxy.protocol.packet.config.ClientboundCustomReportDetailsPacket;
import com.velocitypowered.proxy.protocol.packet.config.ClientboundServerLinksPacket;
import com.velocitypowered.proxy.protocol.packet.config.FinishedUpdatePacket;
import com.velocitypowered.proxy.protocol.packet.config.KnownPacksPacket;
import com.velocitypowered.proxy.protocol.packet.config.RegistrySyncPacket;
import com.velocitypowered.proxy.protocol.packet.config.StartUpdatePacket;
import com.velocitypowered.proxy.protocol.packet.config.TagsUpdatePacket;
import com.velocitypowered.proxy.protocol.packet.title.LegacyTitlePacket;
import com.velocitypowered.proxy.protocol.packet.title.TitleActionbarPacket;
import com.velocitypowered.proxy.protocol.packet.title.TitleClearPacket;
import com.velocitypowered.proxy.protocol.packet.title.TitleSubtitlePacket;
import com.velocitypowered.proxy.protocol.packet.title.TitleTextPacket;
import com.velocitypowered.proxy.protocol.packet.title.TitleTimesPacket;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum StateRegistry {
    HANDSHAKE{
        {
            this.serverbound.register(HandshakePacket.class, HandshakePacket::new, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_7_2, false));
        }
    }
    ,
    STATUS{
        {
            this.serverbound.register(StatusRequestPacket.class, () -> StatusRequestPacket.INSTANCE, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.serverbound.register(StatusPingPacket.class, StatusPingPacket::new, StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.clientbound.register(StatusResponsePacket.class, StatusResponsePacket::new, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.clientbound.register(StatusPingPacket.class, StatusPingPacket::new, StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_7_2, false));
        }
    }
    ,
    CONFIG{
        {
            this.serverbound.register(ClientSettingsPacket.class, ClientSettingsPacket::new, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_20_2, false));
            this.serverbound.register(ServerboundCookieResponsePacket.class, ServerboundCookieResponsePacket::new, StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.serverbound.register(PluginMessagePacket.class, PluginMessagePacket::new, StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.serverbound.register(FinishedUpdatePacket.class, () -> FinishedUpdatePacket.INSTANCE, StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(3, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.serverbound.register(KeepAlivePacket.class, KeepAlivePacket::new, StateRegistry.map(3, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.serverbound.register(PingIdentifyPacket.class, PingIdentifyPacket::new, StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.serverbound.register(ResourcePackResponsePacket.class, ResourcePackResponsePacket::new, StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(6, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.serverbound.register(KnownPacksPacket.class, KnownPacksPacket::new, StateRegistry.map(7, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(ClientboundCookieRequestPacket.class, ClientboundCookieRequestPacket::new, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(PluginMessagePacket.class, PluginMessagePacket::new, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(DisconnectPacket.class, () -> new DisconnectPacket(this), StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(FinishedUpdatePacket.class, () -> FinishedUpdatePacket.INSTANCE, StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(3, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(KeepAlivePacket.class, KeepAlivePacket::new, StateRegistry.map(3, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(PingIdentifyPacket.class, PingIdentifyPacket::new, StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(RegistrySyncPacket.class, RegistrySyncPacket::new, StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(7, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(RemoveResourcePackPacket.class, RemoveResourcePackPacket::new, StateRegistry.map(6, ProtocolVersion.MINECRAFT_1_20_3, false), StateRegistry.map(8, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(ResourcePackRequestPacket.class, ResourcePackRequestPacket::new, StateRegistry.map(6, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(7, ProtocolVersion.MINECRAFT_1_20_3, false), StateRegistry.map(9, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(ClientboundStoreCookiePacket.class, ClientboundStoreCookiePacket::new, StateRegistry.map(10, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(TransferPacket.class, TransferPacket::new, StateRegistry.map(11, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(ActiveFeaturesPacket.class, ActiveFeaturesPacket::new, StateRegistry.map(7, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(8, ProtocolVersion.MINECRAFT_1_20_3, false), StateRegistry.map(12, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(TagsUpdatePacket.class, TagsUpdatePacket::new, StateRegistry.map(8, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(9, ProtocolVersion.MINECRAFT_1_20_3, false), StateRegistry.map(13, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(KnownPacksPacket.class, KnownPacksPacket::new, StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(ClientboundCustomReportDetailsPacket.class, ClientboundCustomReportDetailsPacket::new, StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_21, false));
            this.clientbound.register(ClientboundServerLinksPacket.class, ClientboundServerLinksPacket::new, StateRegistry.map(16, ProtocolVersion.MINECRAFT_1_21, false));
            this.clientbound.register(DialogClearPacket.class, () -> DialogClearPacket.INSTANCE, StateRegistry.map(17, ProtocolVersion.MINECRAFT_1_21_6, false));
            this.clientbound.register(DialogShowPacket.class, () -> new DialogShowPacket(this), StateRegistry.map(18, ProtocolVersion.MINECRAFT_1_21_6, false));
        }
    }
    ,
    PLAY{
        {
            this.serverbound.fallback = false;
            this.clientbound.fallback = false;
            this.serverbound.register(TabCompleteRequestPacket.class, TabCompleteRequestPacket::new, StateRegistry.map(20, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_12, false), StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_12_1, false), StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(6, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(8, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(9, ProtocolVersion.MINECRAFT_1_19_1, false), StateRegistry.map(8, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(9, ProtocolVersion.MINECRAFT_1_19_4, false), StateRegistry.map(10, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(11, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(13, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_21_6, false));
            this.serverbound.register(LegacyChatPacket.class, LegacyChatPacket::new, StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(3, ProtocolVersion.MINECRAFT_1_12, false), StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_12_1, false), StateRegistry.map(3, ProtocolVersion.MINECRAFT_1_14, ProtocolVersion.MINECRAFT_1_18_2, false));
            this.serverbound.register(ChatAcknowledgementPacket.class, ChatAcknowledgementPacket::new, StateRegistry.map(3, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_21_6, false));
            this.serverbound.register(KeyedPlayerCommandPacket.class, KeyedPlayerCommandPacket::new, StateRegistry.map(3, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_19_1, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.serverbound.register(KeyedPlayerChatPacket.class, KeyedPlayerChatPacket::new, StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_19_1, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.serverbound.register(SessionPlayerCommandPacket.class, SessionPlayerCommandPacket::new, StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(6, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(7, ProtocolVersion.MINECRAFT_1_21_6, false));
            this.serverbound.register(UnsignedPlayerCommandPacket.class, UnsignedPlayerCommandPacket::new, StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(6, ProtocolVersion.MINECRAFT_1_21_6, false));
            this.serverbound.register(SessionPlayerChatPacket.class, SessionPlayerChatPacket::new, StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(6, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(7, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(8, ProtocolVersion.MINECRAFT_1_21_6, false));
            this.serverbound.register(ClientSettingsPacket.class, ClientSettingsPacket::new, StateRegistry.map(21, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_12, false), StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_12_1, false), StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(7, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(8, ProtocolVersion.MINECRAFT_1_19_1, false), StateRegistry.map(7, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(8, ProtocolVersion.MINECRAFT_1_19_4, false), StateRegistry.map(9, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(10, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(12, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(13, ProtocolVersion.MINECRAFT_1_21_6, false));
            this.serverbound.register(ServerboundCookieResponsePacket.class, ServerboundCookieResponsePacket::new, StateRegistry.map(17, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(19, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(20, ProtocolVersion.MINECRAFT_1_21_6, false));
            this.serverbound.register(PluginMessagePacket.class, PluginMessagePacket::new, StateRegistry.map(23, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(9, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(10, ProtocolVersion.MINECRAFT_1_12, false), StateRegistry.map(9, ProtocolVersion.MINECRAFT_1_12_1, false), StateRegistry.map(10, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(11, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(10, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(12, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(13, ProtocolVersion.MINECRAFT_1_19_1, false), StateRegistry.map(12, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(13, ProtocolVersion.MINECRAFT_1_19_4, false), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(16, ProtocolVersion.MINECRAFT_1_20_3, false), StateRegistry.map(18, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(20, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(21, ProtocolVersion.MINECRAFT_1_21_6, false));
            this.serverbound.register(KeepAlivePacket.class, KeepAlivePacket::new, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(11, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(12, ProtocolVersion.MINECRAFT_1_12, false), StateRegistry.map(11, ProtocolVersion.MINECRAFT_1_12_1, false), StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(16, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(17, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(18, ProtocolVersion.MINECRAFT_1_19_1, false), StateRegistry.map(17, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(18, ProtocolVersion.MINECRAFT_1_19_4, false), StateRegistry.map(20, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(21, ProtocolVersion.MINECRAFT_1_20_3, false), StateRegistry.map(24, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(26, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(27, ProtocolVersion.MINECRAFT_1_21_6, false));
            this.serverbound.register(ResourcePackResponsePacket.class, ResourcePackResponsePacket::new, StateRegistry.map(25, ProtocolVersion.MINECRAFT_1_8, false), StateRegistry.map(22, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(24, ProtocolVersion.MINECRAFT_1_12, false), StateRegistry.map(29, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(31, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(32, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(33, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(35, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(36, ProtocolVersion.MINECRAFT_1_19_1, false), StateRegistry.map(39, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(40, ProtocolVersion.MINECRAFT_1_20_3, false), StateRegistry.map(43, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(45, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(47, ProtocolVersion.MINECRAFT_1_21_4, false), StateRegistry.map(48, ProtocolVersion.MINECRAFT_1_21_6, false));
            this.serverbound.register(FinishedUpdatePacket.class, () -> FinishedUpdatePacket.INSTANCE, StateRegistry.map(11, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(12, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_21_6, false));
            this.clientbound.register(BossBarPacket.class, BossBarPacket::new, StateRegistry.map(12, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(13, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(12, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(13, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(10, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(11, ProtocolVersion.MINECRAFT_1_19_4, false), StateRegistry.map(10, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(9, ProtocolVersion.MINECRAFT_1_21_5, false));
            this.clientbound.register(LegacyChatPacket.class, LegacyChatPacket::new, StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_7_2, true), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_9, true), StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_13, true), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_15, true), StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_16, true), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_17, ProtocolVersion.MINECRAFT_1_18_2, true));
            this.clientbound.register(TabCompleteResponsePacket.class, TabCompleteResponsePacket::new, StateRegistry.map(58, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(16, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(17, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(16, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(17, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(13, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_19_4, false), StateRegistry.map(16, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_21_5, false));
            this.clientbound.register(AvailableCommandsPacket.class, AvailableCommandsPacket::new, StateRegistry.map(17, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(18, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(17, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(16, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(18, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(16, ProtocolVersion.MINECRAFT_1_19_4, false), StateRegistry.map(17, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(16, ProtocolVersion.MINECRAFT_1_21_5, false));
            this.clientbound.register(ClientboundCookieRequestPacket.class, ClientboundCookieRequestPacket::new, StateRegistry.map(22, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(21, ProtocolVersion.MINECRAFT_1_21_5, false));
            this.clientbound.register(PluginMessagePacket.class, PluginMessagePacket::new, StateRegistry.map(63, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(24, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(25, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(24, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(25, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(24, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(23, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(24, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(21, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(22, ProtocolVersion.MINECRAFT_1_19_1, false), StateRegistry.map(21, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(23, ProtocolVersion.MINECRAFT_1_19_4, false), StateRegistry.map(24, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(25, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(24, ProtocolVersion.MINECRAFT_1_21_5, false));
            this.clientbound.register(DisconnectPacket.class, () -> new DisconnectPacket(this), StateRegistry.map(64, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(26, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(27, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(26, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(27, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(26, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(25, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(26, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(23, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(25, ProtocolVersion.MINECRAFT_1_19_1, false), StateRegistry.map(23, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(26, ProtocolVersion.MINECRAFT_1_19_4, false), StateRegistry.map(27, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(29, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(28, ProtocolVersion.MINECRAFT_1_21_5, false));
            this.clientbound.register(KeepAlivePacket.class, KeepAlivePacket::new, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(31, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(33, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(32, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(33, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(32, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(31, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(33, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(30, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(32, ProtocolVersion.MINECRAFT_1_19_1, false), StateRegistry.map(31, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(35, ProtocolVersion.MINECRAFT_1_19_4, false), StateRegistry.map(36, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(38, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(39, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(38, ProtocolVersion.MINECRAFT_1_21_5, false));
            this.clientbound.register(JoinGamePacket.class, JoinGamePacket::new, StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(35, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(37, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(37, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(38, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(37, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(36, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(38, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(35, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(37, ProtocolVersion.MINECRAFT_1_19_1, false), StateRegistry.map(36, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(40, ProtocolVersion.MINECRAFT_1_19_4, false), StateRegistry.map(41, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(43, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(44, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(43, ProtocolVersion.MINECRAFT_1_21_5, false));
            this.clientbound.register(RespawnPacket.class, RespawnPacket::new, StateRegistry.map(7, ProtocolVersion.MINECRAFT_1_7_2, true), StateRegistry.map(51, ProtocolVersion.MINECRAFT_1_9, true), StateRegistry.map(52, ProtocolVersion.MINECRAFT_1_12, true), StateRegistry.map(53, ProtocolVersion.MINECRAFT_1_12_1, true), StateRegistry.map(56, ProtocolVersion.MINECRAFT_1_13, true), StateRegistry.map(58, ProtocolVersion.MINECRAFT_1_14, true), StateRegistry.map(59, ProtocolVersion.MINECRAFT_1_15, true), StateRegistry.map(58, ProtocolVersion.MINECRAFT_1_16, true), StateRegistry.map(57, ProtocolVersion.MINECRAFT_1_16_2, true), StateRegistry.map(61, ProtocolVersion.MINECRAFT_1_17, true), StateRegistry.map(59, ProtocolVersion.MINECRAFT_1_19, true), StateRegistry.map(62, ProtocolVersion.MINECRAFT_1_19_1, true), StateRegistry.map(61, ProtocolVersion.MINECRAFT_1_19_3, true), StateRegistry.map(65, ProtocolVersion.MINECRAFT_1_19_4, true), StateRegistry.map(67, ProtocolVersion.MINECRAFT_1_20_2, true), StateRegistry.map(69, ProtocolVersion.MINECRAFT_1_20_3, true), StateRegistry.map(71, ProtocolVersion.MINECRAFT_1_20_5, true), StateRegistry.map(76, ProtocolVersion.MINECRAFT_1_21_2, true), StateRegistry.map(75, ProtocolVersion.MINECRAFT_1_21_5, true));
            this.clientbound.register(RemoveResourcePackPacket.class, RemoveResourcePackPacket::new, StateRegistry.map(67, ProtocolVersion.MINECRAFT_1_20_3, false), StateRegistry.map(69, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(74, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(73, ProtocolVersion.MINECRAFT_1_21_5, false));
            this.clientbound.register(ResourcePackRequestPacket.class, ResourcePackRequestPacket::new, StateRegistry.map(72, ProtocolVersion.MINECRAFT_1_8, false), StateRegistry.map(50, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(51, ProtocolVersion.MINECRAFT_1_12, false), StateRegistry.map(52, ProtocolVersion.MINECRAFT_1_12_1, false), StateRegistry.map(55, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(57, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(58, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(57, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(56, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(60, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(58, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(61, ProtocolVersion.MINECRAFT_1_19_1, false), StateRegistry.map(60, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(64, ProtocolVersion.MINECRAFT_1_19_4, false), StateRegistry.map(66, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(68, ProtocolVersion.MINECRAFT_1_20_3, false), StateRegistry.map(70, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(75, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(74, ProtocolVersion.MINECRAFT_1_21_5, false));
            this.clientbound.register(HeaderAndFooterPacket.class, HeaderAndFooterPacket::new, StateRegistry.map(71, ProtocolVersion.MINECRAFT_1_8, true), StateRegistry.map(72, ProtocolVersion.MINECRAFT_1_9, true), StateRegistry.map(71, ProtocolVersion.MINECRAFT_1_9_4, true), StateRegistry.map(73, ProtocolVersion.MINECRAFT_1_12, true), StateRegistry.map(74, ProtocolVersion.MINECRAFT_1_12_1, true), StateRegistry.map(78, ProtocolVersion.MINECRAFT_1_13, true), StateRegistry.map(83, ProtocolVersion.MINECRAFT_1_14, true), StateRegistry.map(84, ProtocolVersion.MINECRAFT_1_15, true), StateRegistry.map(83, ProtocolVersion.MINECRAFT_1_16, true), StateRegistry.map(94, ProtocolVersion.MINECRAFT_1_17, true), StateRegistry.map(95, ProtocolVersion.MINECRAFT_1_18, true), StateRegistry.map(96, ProtocolVersion.MINECRAFT_1_19, true), StateRegistry.map(99, ProtocolVersion.MINECRAFT_1_19_1, true), StateRegistry.map(97, ProtocolVersion.MINECRAFT_1_19_3, true), StateRegistry.map(101, ProtocolVersion.MINECRAFT_1_19_4, true), StateRegistry.map(104, ProtocolVersion.MINECRAFT_1_20_2, true), StateRegistry.map(106, ProtocolVersion.MINECRAFT_1_20_3, true), StateRegistry.map(109, ProtocolVersion.MINECRAFT_1_20_5, true), StateRegistry.map(116, ProtocolVersion.MINECRAFT_1_21_2, true), StateRegistry.map(115, ProtocolVersion.MINECRAFT_1_21_5, true));
            this.clientbound.register(LegacyTitlePacket.class, LegacyTitlePacket::new, StateRegistry.map(69, ProtocolVersion.MINECRAFT_1_8, true), StateRegistry.map(69, ProtocolVersion.MINECRAFT_1_9, true), StateRegistry.map(71, ProtocolVersion.MINECRAFT_1_12, true), StateRegistry.map(72, ProtocolVersion.MINECRAFT_1_12_1, true), StateRegistry.map(75, ProtocolVersion.MINECRAFT_1_13, true), StateRegistry.map(79, ProtocolVersion.MINECRAFT_1_14, true), StateRegistry.map(80, ProtocolVersion.MINECRAFT_1_15, true), StateRegistry.map(79, ProtocolVersion.MINECRAFT_1_16, ProtocolVersion.MINECRAFT_1_16_4, true));
            this.clientbound.register(TitleSubtitlePacket.class, TitleSubtitlePacket::new, StateRegistry.map(87, ProtocolVersion.MINECRAFT_1_17, true), StateRegistry.map(88, ProtocolVersion.MINECRAFT_1_18, true), StateRegistry.map(91, ProtocolVersion.MINECRAFT_1_19_1, true), StateRegistry.map(89, ProtocolVersion.MINECRAFT_1_19_3, true), StateRegistry.map(93, ProtocolVersion.MINECRAFT_1_19_4, true), StateRegistry.map(95, ProtocolVersion.MINECRAFT_1_20_2, true), StateRegistry.map(97, ProtocolVersion.MINECRAFT_1_20_3, true), StateRegistry.map(99, ProtocolVersion.MINECRAFT_1_20_5, true), StateRegistry.map(106, ProtocolVersion.MINECRAFT_1_21_2, true), StateRegistry.map(105, ProtocolVersion.MINECRAFT_1_21_5, true));
            this.clientbound.register(TitleTextPacket.class, TitleTextPacket::new, StateRegistry.map(89, ProtocolVersion.MINECRAFT_1_17, true), StateRegistry.map(90, ProtocolVersion.MINECRAFT_1_18, true), StateRegistry.map(93, ProtocolVersion.MINECRAFT_1_19_1, true), StateRegistry.map(91, ProtocolVersion.MINECRAFT_1_19_3, true), StateRegistry.map(95, ProtocolVersion.MINECRAFT_1_19_4, true), StateRegistry.map(97, ProtocolVersion.MINECRAFT_1_20_2, true), StateRegistry.map(99, ProtocolVersion.MINECRAFT_1_20_3, true), StateRegistry.map(101, ProtocolVersion.MINECRAFT_1_20_5, true), StateRegistry.map(108, ProtocolVersion.MINECRAFT_1_21_2, true), StateRegistry.map(107, ProtocolVersion.MINECRAFT_1_21_5, true));
            this.clientbound.register(TitleActionbarPacket.class, TitleActionbarPacket::new, StateRegistry.map(65, ProtocolVersion.MINECRAFT_1_17, true), StateRegistry.map(64, ProtocolVersion.MINECRAFT_1_19, true), StateRegistry.map(67, ProtocolVersion.MINECRAFT_1_19_1, true), StateRegistry.map(66, ProtocolVersion.MINECRAFT_1_19_3, true), StateRegistry.map(70, ProtocolVersion.MINECRAFT_1_19_4, true), StateRegistry.map(72, ProtocolVersion.MINECRAFT_1_20_2, true), StateRegistry.map(74, ProtocolVersion.MINECRAFT_1_20_3, true), StateRegistry.map(76, ProtocolVersion.MINECRAFT_1_20_5, true), StateRegistry.map(81, ProtocolVersion.MINECRAFT_1_21_2, true), StateRegistry.map(80, ProtocolVersion.MINECRAFT_1_21_5, true));
            this.clientbound.register(TitleTimesPacket.class, TitleTimesPacket::new, StateRegistry.map(90, ProtocolVersion.MINECRAFT_1_17, true), StateRegistry.map(91, ProtocolVersion.MINECRAFT_1_18, true), StateRegistry.map(94, ProtocolVersion.MINECRAFT_1_19_1, true), StateRegistry.map(92, ProtocolVersion.MINECRAFT_1_19_3, true), StateRegistry.map(96, ProtocolVersion.MINECRAFT_1_19_4, true), StateRegistry.map(98, ProtocolVersion.MINECRAFT_1_20_2, true), StateRegistry.map(100, ProtocolVersion.MINECRAFT_1_20_3, true), StateRegistry.map(102, ProtocolVersion.MINECRAFT_1_20_5, true), StateRegistry.map(109, ProtocolVersion.MINECRAFT_1_21_2, true), StateRegistry.map(108, ProtocolVersion.MINECRAFT_1_21_5, true));
            this.clientbound.register(TitleClearPacket.class, TitleClearPacket::new, StateRegistry.map(16, ProtocolVersion.MINECRAFT_1_17, true), StateRegistry.map(13, ProtocolVersion.MINECRAFT_1_19, true), StateRegistry.map(12, ProtocolVersion.MINECRAFT_1_19_3, true), StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_19_4, true), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_20_2, true), StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_21_5, true));
            this.clientbound.register(LegacyPlayerListItemPacket.class, LegacyPlayerListItemPacket::new, StateRegistry.map(56, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(45, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(46, ProtocolVersion.MINECRAFT_1_12_1, false), StateRegistry.map(48, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(51, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(52, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(51, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(50, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(54, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(52, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(55, ProtocolVersion.MINECRAFT_1_19_1, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.clientbound.register(RemovePlayerInfoPacket.class, RemovePlayerInfoPacket::new, StateRegistry.map(53, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(57, ProtocolVersion.MINECRAFT_1_19_4, false), StateRegistry.map(59, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(61, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(63, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(62, ProtocolVersion.MINECRAFT_1_21_5, false));
            this.clientbound.register(UpsertPlayerInfoPacket.class, UpsertPlayerInfoPacket::new, StateRegistry.map(54, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(58, ProtocolVersion.MINECRAFT_1_19_4, false), StateRegistry.map(60, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(62, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(64, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(63, ProtocolVersion.MINECRAFT_1_21_5, false));
            this.clientbound.register(ClientboundStoreCookiePacket.class, ClientboundStoreCookiePacket::new, StateRegistry.map(107, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(114, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(113, ProtocolVersion.MINECRAFT_1_21_5, false));
            this.clientbound.register(SystemChatPacket.class, SystemChatPacket::new, StateRegistry.map(95, ProtocolVersion.MINECRAFT_1_19, true), StateRegistry.map(98, ProtocolVersion.MINECRAFT_1_19_1, true), StateRegistry.map(96, ProtocolVersion.MINECRAFT_1_19_3, true), StateRegistry.map(100, ProtocolVersion.MINECRAFT_1_19_4, true), StateRegistry.map(103, ProtocolVersion.MINECRAFT_1_20_2, true), StateRegistry.map(105, ProtocolVersion.MINECRAFT_1_20_3, true), StateRegistry.map(108, ProtocolVersion.MINECRAFT_1_20_5, true), StateRegistry.map(115, ProtocolVersion.MINECRAFT_1_21_2, true), StateRegistry.map(114, ProtocolVersion.MINECRAFT_1_21_5, true));
            this.clientbound.register(PlayerChatCompletionPacket.class, PlayerChatCompletionPacket::new, StateRegistry.map(21, ProtocolVersion.MINECRAFT_1_19_1, true), StateRegistry.map(20, ProtocolVersion.MINECRAFT_1_19_3, true), StateRegistry.map(22, ProtocolVersion.MINECRAFT_1_19_4, true), StateRegistry.map(23, ProtocolVersion.MINECRAFT_1_20_2, true), StateRegistry.map(24, ProtocolVersion.MINECRAFT_1_20_5, true), StateRegistry.map(23, ProtocolVersion.MINECRAFT_1_21_5, true));
            this.clientbound.register(ServerDataPacket.class, ServerDataPacket::new, StateRegistry.map(63, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(66, ProtocolVersion.MINECRAFT_1_19_1, false), StateRegistry.map(65, ProtocolVersion.MINECRAFT_1_19_3, false), StateRegistry.map(69, ProtocolVersion.MINECRAFT_1_19_4, false), StateRegistry.map(71, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(73, ProtocolVersion.MINECRAFT_1_20_3, false), StateRegistry.map(75, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(80, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(79, ProtocolVersion.MINECRAFT_1_21_5, false));
            this.clientbound.register(StartUpdatePacket.class, () -> StartUpdatePacket.INSTANCE, StateRegistry.map(101, ProtocolVersion.MINECRAFT_1_20_2, false), StateRegistry.map(103, ProtocolVersion.MINECRAFT_1_20_3, false), StateRegistry.map(105, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(112, ProtocolVersion.MINECRAFT_1_21_2, false), StateRegistry.map(111, ProtocolVersion.MINECRAFT_1_21_5, false));
            this.clientbound.register(BundleDelimiterPacket.class, () -> BundleDelimiterPacket.INSTANCE, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_19_4, false));
            this.clientbound.register(TransferPacket.class, TransferPacket::new, StateRegistry.map(115, ProtocolVersion.MINECRAFT_1_20_5, false), StateRegistry.map(122, ProtocolVersion.MINECRAFT_1_21_2, false));
            this.clientbound.register(ClientboundCustomReportDetailsPacket.class, ClientboundCustomReportDetailsPacket::new, StateRegistry.map(122, ProtocolVersion.MINECRAFT_1_21, false), StateRegistry.map(129, ProtocolVersion.MINECRAFT_1_21_2, false));
            this.clientbound.register(ClientboundServerLinksPacket.class, ClientboundServerLinksPacket::new, StateRegistry.map(123, ProtocolVersion.MINECRAFT_1_21, false), StateRegistry.map(130, ProtocolVersion.MINECRAFT_1_21_2, false));
        }
    }
    ,
    LOGIN{
        {
            this.serverbound.register(ServerLoginPacket.class, ServerLoginPacket::new, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.serverbound.register(EncryptionResponsePacket.class, EncryptionResponsePacket::new, StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.serverbound.register(LoginPluginResponsePacket.class, LoginPluginResponsePacket::new, StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_13, false));
            this.serverbound.register(LoginAcknowledgedPacket.class, LoginAcknowledgedPacket::new, StateRegistry.map(3, ProtocolVersion.MINECRAFT_1_20_2, false));
            this.serverbound.register(ServerboundCookieResponsePacket.class, ServerboundCookieResponsePacket::new, StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_20_5, false));
            this.clientbound.register(DisconnectPacket.class, () -> new DisconnectPacket(this), StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.clientbound.register(EncryptionRequestPacket.class, EncryptionRequestPacket::new, StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.clientbound.register(ServerLoginSuccessPacket.class, ServerLoginSuccessPacket::new, StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.clientbound.register(SetCompressionPacket.class, SetCompressionPacket::new, StateRegistry.map(3, ProtocolVersion.MINECRAFT_1_8, false));
            this.clientbound.register(LoginPluginMessagePacket.class, LoginPluginMessagePacket::new, StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_13, false));
            this.clientbound.register(ClientboundCookieRequestPacket.class, ClientboundCookieRequestPacket::new, StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_20_5, false));
        }
    };

    public static final int STATUS_ID = 1;
    public static final int LOGIN_ID = 2;
    public static final int TRANSFER_ID = 3;
    protected final PacketRegistry clientbound = new PacketRegistry(ProtocolUtils.Direction.CLIENTBOUND, this);
    protected final PacketRegistry serverbound = new PacketRegistry(ProtocolUtils.Direction.SERVERBOUND, this);

    public PacketRegistry.ProtocolRegistry getProtocolRegistry(ProtocolUtils.Direction direction, ProtocolVersion version) {
        return (direction == ProtocolUtils.Direction.SERVERBOUND ? this.serverbound : this.clientbound).getProtocolRegistry(version);
    }

    public ProtocolState toProtocolState() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case HANDSHAKE -> ProtocolState.HANDSHAKE;
            case STATUS -> ProtocolState.STATUS;
            case LOGIN -> ProtocolState.LOGIN;
            case CONFIG -> ProtocolState.CONFIGURATION;
            case PLAY -> ProtocolState.PLAY;
        };
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
    private static PacketMapping map(int id, ProtocolVersion version, boolean encodeOnly) {
        return StateRegistry.map(id, version, null, encodeOnly);
    }

    private static PacketMapping map(int id, ProtocolVersion version, ProtocolVersion lastValidProtocolVersion, boolean encodeOnly) {
        return new PacketMapping(id, version, lastValidProtocolVersion, encodeOnly);
    }

    public static class PacketRegistry {
        private final ProtocolUtils.Direction direction;
        private final StateRegistry registry;
        private final Map<ProtocolVersion, ProtocolRegistry> versions;
        private boolean fallback = true;

        PacketRegistry(ProtocolUtils.Direction direction, StateRegistry registry) {
            this.direction = direction;
            this.registry = registry;
            EnumMap<ProtocolVersion, ProtocolRegistry> mutableVersions = new EnumMap<ProtocolVersion, ProtocolRegistry>(ProtocolVersion.class);
            for (ProtocolVersion version : ProtocolVersion.values()) {
                if (version.isLegacy() || version.isUnknown()) continue;
                mutableVersions.put(version, new ProtocolRegistry(version));
            }
            this.versions = Collections.unmodifiableMap(mutableVersions);
        }

        ProtocolRegistry getProtocolRegistry(ProtocolVersion version) {
            ProtocolRegistry registry = this.versions.get(version);
            if (registry == null) {
                if (this.fallback) {
                    return this.getProtocolRegistry(ProtocolVersion.MINIMUM_VERSION);
                }
                throw new IllegalArgumentException("Could not find data for protocol version " + String.valueOf(version));
            }
            return registry;
        }

        <P extends MinecraftPacket> void register(Class<P> clazz, Supplier<P> packetSupplier, PacketMapping ... mappings) {
            if (mappings.length == 0) {
                throw new IllegalArgumentException("At least one mapping must be provided.");
            }
            for (int i = 0; i < mappings.length; ++i) {
                ProtocolVersion protocol;
                ProtocolVersion lastInList;
                PacketMapping current = mappings[i];
                PacketMapping next = i + 1 < mappings.length ? mappings[i + 1] : current;
                ProtocolVersion from = current.protocolVersion;
                ProtocolVersion lastValid = current.lastValidProtocolVersion;
                if (lastValid != null) {
                    if (next != current) {
                        throw new IllegalArgumentException("Cannot add a mapping after last valid mapping");
                    }
                    if (from.greaterThan(lastValid)) {
                        throw new IllegalArgumentException("Last mapping version cannot be higher than highest mapping version");
                    }
                }
                ProtocolVersion to = current == next ? (lastValid != null ? lastValid : Iterables.getLast(ProtocolVersion.SUPPORTED_VERSIONS)) : next.protocolVersion;
                ProtocolVersion protocolVersion = lastInList = lastValid != null ? lastValid : Iterables.getLast(ProtocolVersion.SUPPORTED_VERSIONS);
                if (from.noLessThan(to) && from != lastInList) {
                    throw new IllegalArgumentException(String.format("Next mapping version (%s) should be lower then current (%s)", to, from));
                }
                Iterator iterator = EnumSet.range(from, to).iterator();
                while (iterator.hasNext() && ((protocol = (ProtocolVersion)iterator.next()) != to || next == current)) {
                    ProtocolRegistry registry = this.versions.get(protocol);
                    if (registry == null) {
                        throw new IllegalArgumentException("Unknown protocol version " + String.valueOf(current.protocolVersion));
                    }
                    if (registry.packetIdToSupplier.containsKey(current.id)) {
                        throw new IllegalArgumentException("Can not register class " + clazz.getSimpleName() + " with id " + current.id + " for " + String.valueOf(registry.version) + " because another packet is already registered");
                    }
                    if (registry.packetClassToId.containsKey(clazz)) {
                        throw new IllegalArgumentException(clazz.getSimpleName() + " is already registered for version " + String.valueOf(registry.version));
                    }
                    if (!current.encodeOnly) {
                        registry.packetIdToSupplier.put(current.id, packetSupplier);
                    }
                    registry.packetClassToId.put((Class<? extends MinecraftPacket>)clazz, current.id);
                }
            }
        }

        public class ProtocolRegistry {
            public final ProtocolVersion version;
            final IntObjectMap<Supplier<? extends MinecraftPacket>> packetIdToSupplier = new IntObjectHashMap<Supplier<? extends MinecraftPacket>>(16, 0.5f);
            final Object2IntMap<Class<? extends MinecraftPacket>> packetClassToId = new Object2IntOpenHashMap<Class<? extends MinecraftPacket>>(16, 0.5f);

            ProtocolRegistry(ProtocolVersion version) {
                this.version = version;
                this.packetClassToId.defaultReturnValue(Integer.MIN_VALUE);
            }

            public @Nullable MinecraftPacket createPacket(int id) {
                Supplier<? extends MinecraftPacket> supplier = this.packetIdToSupplier.get(id);
                if (supplier == null) {
                    return null;
                }
                return supplier.get();
            }

            public int getPacketId(MinecraftPacket packet) {
                int id = this.packetClassToId.getInt(packet.getClass());
                if (id == Integer.MIN_VALUE) {
                    throw new IllegalArgumentException(String.format("Unable to find id for packet of type %s in %s protocol %s phase %s", new Object[]{packet.getClass().getName(), PacketRegistry.this.direction, this.version, PacketRegistry.this.registry}));
                }
                return id;
            }

            public boolean containsPacket(MinecraftPacket packet) {
                return this.packetClassToId.containsKey(packet.getClass());
            }
        }
    }

    public static final class PacketMapping {
        private final int id;
        private final ProtocolVersion protocolVersion;
        private final boolean encodeOnly;
        private final @Nullable ProtocolVersion lastValidProtocolVersion;

        PacketMapping(int id, ProtocolVersion protocolVersion, @Nullable ProtocolVersion lastValidProtocolVersion, boolean packetDecoding) {
            this.id = id;
            this.protocolVersion = protocolVersion;
            this.lastValidProtocolVersion = lastValidProtocolVersion;
            this.encodeOnly = packetDecoding;
        }

        public String toString() {
            return "PacketMapping{id=" + this.id + ", protocolVersion=" + String.valueOf(this.protocolVersion) + ", encodeOnly=" + this.encodeOnly + "}";
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PacketMapping that = (PacketMapping)o;
            return this.id == that.id && this.protocolVersion == that.protocolVersion && this.encodeOnly == that.encodeOnly;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.protocolVersion, this.encodeOnly);
        }
    }
}

