/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.util.DeferredByteBufHolder;
import com.velocitypowered.proxy.protocol.util.PluginMessageUtil;
import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PluginMessagePacket
extends DeferredByteBufHolder
implements MinecraftPacket {
    private @Nullable String channel;

    public PluginMessagePacket() {
        super(null);
    }

    public PluginMessagePacket(String channel, @MonotonicNonNull ByteBuf backing) {
        super(backing);
        this.channel = channel;
    }

    public String getChannel() {
        if (this.channel == null) {
            throw new IllegalStateException("Channel is not specified.");
        }
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Override
    public String toString() {
        return "PluginMessage{channel='" + this.channel + "', data=" + super.toString() + "}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.channel = ProtocolUtils.readString(buf);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_13)) {
            this.channel = PluginMessageUtil.transformLegacyToModernChannel(this.channel);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            this.replace(buf.readRetainedSlice(buf.readableBytes()));
        } else {
            this.replace(ProtocolUtils.readRetainedByteBufSlice17(buf));
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (this.channel == null) {
            throw new IllegalStateException("Channel is not specified.");
        }
        if (this.refCnt() == 0) {
            throw new IllegalStateException("Plugin message contents for " + this.channel + " freed too many times.");
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_13)) {
            ProtocolUtils.writeString(buf, PluginMessageUtil.transformLegacyToModernChannel(this.channel));
        } else {
            ProtocolUtils.writeString(buf, this.channel);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            buf.writeBytes(this.content());
        } else {
            ProtocolUtils.writeByteBuf17(this.content(), buf, true);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    @Override
    public PluginMessagePacket copy() {
        return (PluginMessagePacket)super.copy();
    }

    @Override
    public PluginMessagePacket duplicate() {
        return (PluginMessagePacket)super.duplicate();
    }

    @Override
    public PluginMessagePacket retainedDuplicate() {
        return (PluginMessagePacket)super.retainedDuplicate();
    }

    @Override
    public PluginMessagePacket replace(ByteBuf content) {
        return (PluginMessagePacket)super.replace(content);
    }

    @Override
    public PluginMessagePacket retain() {
        return (PluginMessagePacket)super.retain();
    }

    @Override
    public PluginMessagePacket retain(int increment) {
        return (PluginMessagePacket)super.retain(increment);
    }

    @Override
    public PluginMessagePacket touch() {
        return (PluginMessagePacket)super.touch();
    }

    @Override
    public PluginMessagePacket touch(Object hint) {
        return (PluginMessagePacket)super.touch(hint);
    }
}

