/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import org.jetbrains.annotations.Nullable;

public class TransferPacket
implements MinecraftPacket {
    private String host;
    private int port;

    public TransferPacket() {
    }

    public TransferPacket(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Nullable
    public InetSocketAddress address() {
        if (this.host == null) {
            return null;
        }
        return new InetSocketAddress(this.host, this.port);
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        this.host = ProtocolUtils.readString(buf);
        this.port = ProtocolUtils.readVarInt(buf);
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ProtocolUtils.writeString(buf, this.host);
        ProtocolUtils.writeVarInt(buf, this.port);
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

