/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.session;

import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.packet.chat.ChatAcknowledgementPacket;
import com.velocitypowered.proxy.protocol.packet.chat.LastSeenMessages;
import com.velocitypowered.proxy.protocol.packet.chat.RateLimitedCommandHandler;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerCommandPacket;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SessionCommandHandler
extends RateLimitedCommandHandler<SessionPlayerCommandPacket> {
    private final ConnectedPlayer player;
    private final VelocityServer server;

    public SessionCommandHandler(ConnectedPlayer player, VelocityServer server) {
        super(player, server);
        this.player = player;
        this.server = server;
    }

    @Override
    public Class<SessionPlayerCommandPacket> packetClass() {
        return SessionPlayerCommandPacket.class;
    }

    private @Nullable MinecraftPacket consumeCommand(SessionPlayerCommandPacket packet) {
        if (packet.lastSeenMessages == null) {
            return null;
        }
        if (packet.isSigned()) {
            logger.fatal("A plugin tried to deny a command with signable component(s). This is not supported. Disconnecting player " + this.player.getUsername() + ". Command packet: " + String.valueOf(packet));
            this.player.disconnect(Component.text("A proxy plugin caused an illegal protocol state. Contact your network administrator."));
            return null;
        }
        int offset = packet.lastSeenMessages.getOffset();
        if (offset != 0) {
            return new ChatAcknowledgementPacket(offset);
        }
        return null;
    }

    private @Nullable MinecraftPacket forwardCommand(SessionPlayerCommandPacket packet, String newCommand) {
        if (newCommand.equals(packet.command)) {
            return packet;
        }
        return this.modifyCommand(packet, newCommand);
    }

    private @Nullable MinecraftPacket modifyCommand(SessionPlayerCommandPacket packet, String newCommand) {
        if (packet.isSigned()) {
            logger.fatal("A plugin tried to change a command with signed component(s). This is not supported. Disconnecting player " + this.player.getUsername() + ". Command packet: " + String.valueOf(packet));
            this.player.disconnect(Component.text("A proxy plugin caused an illegal protocol state. Contact your network administrator."));
            return null;
        }
        return this.player.getChatBuilderFactory().builder().setTimestamp(packet.timeStamp).setLastSeenMessages(packet.lastSeenMessages).asPlayer(this.player).message("/" + newCommand).toServer();
    }

    @Override
    public void handlePlayerCommandInternal(SessionPlayerCommandPacket packet) {
        this.queueCommandResult(this.server, this.player, (event, newLastSeenMessages) -> {
            SessionPlayerCommandPacket fixedPacket = packet.withLastSeenMessages((LastSeenMessages)newLastSeenMessages);
            CommandExecuteEvent.CommandResult result = event.getResult();
            if (result == CommandExecuteEvent.CommandResult.denied()) {
                return CompletableFuture.completedFuture(this.consumeCommand(fixedPacket));
            }
            String commandToRun = result.getCommand().orElse(fixedPacket.command);
            if (result.isForwardToServer()) {
                return CompletableFuture.completedFuture(this.forwardCommand(fixedPacket, commandToRun));
            }
            return this.runCommand(this.server, this.player, commandToRun, hasRun -> {
                if (hasRun.booleanValue()) {
                    return this.consumeCommand(fixedPacket);
                }
                return this.forwardCommand(fixedPacket, commandToRun);
            });
        }, packet.command, packet.timeStamp, packet.lastSeenMessages, new CommandExecuteEvent.InvocationInfo(packet.getEventSignedState(), CommandExecuteEvent.Source.PLAYER));
    }
}

