/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.config;

import com.google.common.collect.ImmutableMap;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.Map;

public class TagsUpdatePacket
implements MinecraftPacket {
    private Map<String, Map<String, int[]>> tags;

    public TagsUpdatePacket(Map<String, Map<String, int[]>> tags) {
        this.tags = tags;
    }

    public TagsUpdatePacket() {
        this.tags = Map.of();
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int size = ProtocolUtils.readVarInt(buf);
        for (int i = 0; i < size; ++i) {
            String key = ProtocolUtils.readString(buf);
            int innerSize = ProtocolUtils.readVarInt(buf);
            ImmutableMap.Builder<String, int[]> innerBuilder = ImmutableMap.builder();
            for (int j = 0; j < innerSize; ++j) {
                String innerKey = ProtocolUtils.readString(buf);
                int[] innerValue = ProtocolUtils.readVarIntArray(buf);
                innerBuilder.put(innerKey, innerValue);
            }
            builder.put(key, innerBuilder.build());
        }
        this.tags = builder.build();
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ProtocolUtils.writeVarInt(buf, this.tags.size());
        for (Map.Entry<String, Map<String, int[]>> entry : this.tags.entrySet()) {
            ProtocolUtils.writeString(buf, entry.getKey());
            ProtocolUtils.writeVarInt(buf, entry.getValue().size());
            for (Map.Entry<String, int[]> innerEntry : entry.getValue().entrySet()) {
                ProtocolUtils.writeString(buf, innerEntry.getKey());
                ProtocolUtils.writeVarIntArray(buf, innerEntry.getValue());
            }
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

