/*
 * Decompiled with CFR 0.152.
 */
package io.github.waterfallmc.waterfall.conf;

import com.google.common.base.Joiner;
import java.io.File;
import net.md_5.bungee.conf.Configuration;
import net.md_5.bungee.conf.YamlConfig;
import net.md_5.bungee.protocol.ProtocolConstants;

public class WaterfallConfiguration
extends Configuration {
    private boolean metrics = true;
    private boolean logServerListPing = false;
    private String gameVersion;
    private int tabThrottle = 1000;

    @Override
    public void load() {
        super.load();
        YamlConfig config = new YamlConfig(new File("waterfall.yml"));
        config.load(false);
        this.metrics = config.getBoolean("metrics", this.metrics);
        this.logServerListPing = config.getBoolean("log_server_list_ping", this.logServerListPing);
        this.tabThrottle = config.getInt("throttling.tab_complete", this.tabThrottle);
        this.gameVersion = config.getString("game_version", "").isEmpty() ? Joiner.on(", ").join(ProtocolConstants.SUPPORTED_VERSIONS) : config.getString("game_version", "");
    }

    @Override
    public boolean isMetrics() {
        return this.metrics;
    }

    @Override
    public int getTabThrottle() {
        return this.tabThrottle;
    }

    @Override
    public boolean isLogServerListPing() {
        return this.logServerListPing;
    }

    @Override
    public String getGameVersion() {
        return this.gameVersion;
    }
}

