/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;

public class EntityEffect
extends DefinedPacket {
    private int entityId;
    private int effectId;
    private int amplifier;
    private int duration;
    private boolean hideParticles;

    @Override
    public void read(ByteBuf buf) {
        this.entityId = EntityEffect.readVarInt(buf);
        this.effectId = buf.readUnsignedByte();
        this.amplifier = buf.readUnsignedByte();
        this.duration = EntityEffect.readVarInt(buf);
        this.hideParticles = buf.readBoolean();
    }

    @Override
    public void write(ByteBuf buf) {
        EntityEffect.writeVarInt(this.entityId, buf);
        buf.writeByte(this.effectId);
        buf.writeByte(this.amplifier);
        EntityEffect.writeVarInt(this.duration, buf);
        buf.writeBoolean(this.hideParticles);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getEffectId() {
        return this.effectId;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isHideParticles() {
        return this.hideParticles;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setEffectId(int effectId) {
        this.effectId = effectId;
    }

    public void setAmplifier(int amplifier) {
        this.amplifier = amplifier;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setHideParticles(boolean hideParticles) {
        this.hideParticles = hideParticles;
    }

    @Override
    public String toString() {
        return "EntityEffect(entityId=" + this.getEntityId() + ", effectId=" + this.getEffectId() + ", amplifier=" + this.getAmplifier() + ", duration=" + this.getDuration() + ", hideParticles=" + this.isHideParticles() + ")";
    }

    public EntityEffect() {
    }

    @ConstructorProperties(value={"entityId", "effectId", "amplifier", "duration", "hideParticles"})
    public EntityEffect(int entityId, int effectId, int amplifier, int duration, boolean hideParticles) {
        this.entityId = entityId;
        this.effectId = effectId;
        this.amplifier = amplifier;
        this.duration = duration;
        this.hideParticles = hideParticles;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityEffect)) {
            return false;
        }
        EntityEffect other = (EntityEffect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.getEffectId() != other.getEffectId()) {
            return false;
        }
        if (this.getAmplifier() != other.getAmplifier()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        return this.isHideParticles() == other.isHideParticles();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityEffect;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getEffectId();
        result = result * 59 + this.getAmplifier();
        result = result * 59 + this.getDuration();
        result = result * 59 + (this.isHideParticles() ? 79 : 97);
        return result;
    }
}

