/*
 * Decompiled with CFR 0.152.
 */
package net.minecrell.terminalconsole;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.logging.log4j.LogManager;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;

public abstract class SimpleTerminalConsole {
    protected abstract boolean isRunning();

    protected abstract void runCommand(String var1);

    protected abstract void shutdown();

    protected void processInput(String input) {
        String command = input.trim();
        if (!command.isEmpty()) {
            this.runCommand(command);
        }
    }

    protected LineReader buildReader(LineReaderBuilder builder) {
        LineReader reader = builder.build();
        reader.setOpt(LineReader.Option.DISABLE_EVENT_EXPANSION);
        reader.unsetOpt(LineReader.Option.INSERT_TAB);
        return reader;
    }

    public void start() {
        try {
            Terminal terminal = TerminalConsoleAppender.getTerminal();
            if (terminal != null) {
                this.readCommands(terminal);
            } else {
                this.readCommands(System.in);
            }
        }
        catch (IOException e) {
            LogManager.getLogger("TerminalConsole").error("Failed to read console input", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCommands(Terminal terminal) {
        LineReader reader = this.buildReader(LineReaderBuilder.builder().terminal(terminal));
        TerminalConsoleAppender.setReader(reader);
        try {
            while (this.isRunning()) {
                String line;
                try {
                    line = reader.readLine("> ");
                }
                catch (EndOfFileException ignored) {
                    continue;
                }
                if (line == null) {
                    break;
                }
                this.processInput(line);
            }
        }
        catch (UserInterruptException e) {
            this.shutdown();
        }
        finally {
            TerminalConsoleAppender.setReader(null);
        }
    }

    private void readCommands(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while (this.isRunning() && (line = reader.readLine()) != null) {
                this.processInput(line);
            }
        }
    }
}

