/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.protocol.nbt.NBTTag;
import net.md_5.bungee.protocol.nbt.NBTTagTypes;

public class CompoundTag
extends NBTTag {
    private Map<String, NBTTag> tagMap = new HashMap<String, NBTTag>();

    @Override
    public int getTagIndex() {
        return 10;
    }

    @Override
    public void write(DataOutput to) throws IOException {
        for (Map.Entry<String, NBTTag> entry : this.tagMap.entrySet()) {
            to.writeByte(entry.getValue().getTagIndex());
            if (entry.getValue().getTagIndex() == 0) continue;
            to.writeUTF(entry.getKey());
            entry.getValue().write(to);
        }
        to.writeByte(0);
    }

    @Override
    public void read(DataInput from) throws IOException {
        this.tagMap = new HashMap<String, NBTTag>();
        byte type = from.readByte();
        while (type != 0) {
            String key = from.readUTF();
            NBTTag value = NBTTagTypes.newInstance(type);
            value.read(from);
            this.tagMap.put(key, value);
            type = from.readByte();
        }
    }

    @Override
    public String toString() {
        String ret = "CompoundTag: \n";
        for (Map.Entry<String, NBTTag> entry : this.tagMap.entrySet()) {
            ret = ret + "\t" + entry.getKey() + "\n";
            ret = ret + "\t\t" + entry.getValue().toString() + "\n";
        }
        return ret;
    }
}

