/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.Arrays;
import java.util.Locale;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class PluginMessage
extends DefinedPacket {
    public static final Function<String, String> MODERNISE = new Function<String, String>(){

        @Override
        public String apply(String tag) {
            if (tag.equals("BungeeCord")) {
                return "bungeecord:main";
            }
            if (tag.equals("bungeecord:main")) {
                return "BungeeCord";
            }
            if (tag.indexOf(58) != -1) {
                return tag;
            }
            return "legacy:" + tag.toLowerCase(Locale.ROOT);
        }
    };
    public static final Predicate<PluginMessage> SHOULD_RELAY = new Predicate<PluginMessage>(){

        @Override
        public boolean apply(PluginMessage input) {
            return (input.getTag().equals("REGISTER") || input.getTag().equals("minecraft:register") || input.getTag().equals("MC|Brand") || input.getTag().equals("minecraft:brand")) && input.getData().length < 127;
        }
    };
    private String tag;
    private byte[] data;
    private boolean allowExtendedPacket = false;

    public PluginMessage(String tag, ByteBuf data, boolean allowExtendedPacket) {
        this(tag, ByteBufUtil.getBytes(data), allowExtendedPacket);
    }

    public void setData(byte[] data) {
        this.data = Preconditions.checkNotNull(data, "Null data");
    }

    public void setData(ByteBuf buf) {
        Preconditions.checkNotNull(buf, "Null buffer");
        this.setData(ByteBufUtil.getBytes(buf));
    }

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.tag = protocolVersion >= 393 ? MODERNISE.apply(PluginMessage.readString(buf)) : PluginMessage.readString(buf);
        int maxSize = direction == ProtocolConstants.Direction.TO_SERVER ? Short.MAX_VALUE : 0x100000;
        Preconditions.checkArgument(buf.readableBytes() < maxSize);
        this.data = new byte[buf.readableBytes()];
        buf.readBytes(this.data);
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        PluginMessage.writeString(protocolVersion >= 393 ? MODERNISE.apply(this.tag) : this.tag, buf);
        buf.writeBytes(this.data);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public DataInput getStream() {
        return new DataInputStream(new ByteArrayInputStream(this.data));
    }

    public String getTag() {
        return this.tag;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isAllowExtendedPacket() {
        return this.allowExtendedPacket;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setAllowExtendedPacket(boolean allowExtendedPacket) {
        this.allowExtendedPacket = allowExtendedPacket;
    }

    @Override
    public String toString() {
        return "PluginMessage(tag=" + this.getTag() + ", data=" + Arrays.toString(this.getData()) + ", allowExtendedPacket=" + this.isAllowExtendedPacket() + ")";
    }

    public PluginMessage() {
    }

    public PluginMessage(String tag, byte[] data, boolean allowExtendedPacket) {
        this.tag = tag;
        this.data = data;
        this.allowExtendedPacket = allowExtendedPacket;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginMessage)) {
            return false;
        }
        PluginMessage other = (PluginMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAllowExtendedPacket() != other.isAllowExtendedPacket()) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PluginMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllowExtendedPacket() ? 79 : 97);
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }
}

