/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.entitymap;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInputStream;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.entitymap.EntityMap_1_10;
import net.md_5.bungee.entitymap.EntityMap_1_11;
import net.md_5.bungee.entitymap.EntityMap_1_12;
import net.md_5.bungee.entitymap.EntityMap_1_12_1;
import net.md_5.bungee.entitymap.EntityMap_1_13;
import net.md_5.bungee.entitymap.EntityMap_1_14;
import net.md_5.bungee.entitymap.EntityMap_1_15;
import net.md_5.bungee.entitymap.EntityMap_1_16;
import net.md_5.bungee.entitymap.EntityMap_1_16_2;
import net.md_5.bungee.entitymap.EntityMap_1_8;
import net.md_5.bungee.entitymap.EntityMap_1_9;
import net.md_5.bungee.entitymap.EntityMap_1_9_4;
import net.md_5.bungee.entitymap.EntityMap_Dummy;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import se.llbit.nbt.NamedTag;
import se.llbit.nbt.Tag;

public abstract class EntityMap {
    private final boolean[] clientboundInts = new boolean[256];
    private final boolean[] clientboundVarInts = new boolean[256];
    private final boolean[] serverboundInts = new boolean[256];
    private final boolean[] serverboundVarInts = new boolean[256];

    public static EntityMap getEntityMap(int version) {
        if (ProxyServer.getInstance().getConfig().isDisableEntityMetadataRewrite()) {
            return EntityMap_Dummy.INSTANCE;
        }
        switch (version) {
            case 47: {
                return EntityMap_1_8.INSTANCE;
            }
            case 107: 
            case 108: 
            case 109: {
                return EntityMap_1_9.INSTANCE;
            }
            case 110: {
                return EntityMap_1_9_4.INSTANCE;
            }
            case 210: {
                return EntityMap_1_10.INSTANCE;
            }
            case 315: 
            case 316: {
                return EntityMap_1_11.INSTANCE;
            }
            case 335: {
                return EntityMap_1_12.INSTANCE;
            }
            case 338: 
            case 340: {
                return EntityMap_1_12_1.INSTANCE;
            }
            case 393: 
            case 401: 
            case 404: {
                return EntityMap_1_13.INSTANCE;
            }
            case 477: 
            case 480: 
            case 485: 
            case 490: 
            case 498: {
                return EntityMap_1_14.INSTANCE;
            }
            case 573: 
            case 575: 
            case 578: {
                return EntityMap_1_15.INSTANCE;
            }
            case 735: 
            case 736: {
                return EntityMap_1_16.INSTANCE;
            }
            case 751: 
            case 753: 
            case 754: {
                return EntityMap_1_16_2.INSTANCE_1_16_2;
            }
            case 755: 
            case 756: {
                return EntityMap_1_16_2.INSTANCE_1_17;
            }
            case 757: 
            case 758: {
                return EntityMap_1_16_2.INSTANCE_1_18;
            }
        }
        throw new RuntimeException("Version " + version + " has no entity map");
    }

    protected void addRewrite(int id, ProtocolConstants.Direction direction, boolean varint) {
        if (direction == ProtocolConstants.Direction.TO_CLIENT) {
            if (varint) {
                this.clientboundVarInts[id] = true;
            } else {
                this.clientboundInts[id] = true;
            }
        } else if (varint) {
            this.serverboundVarInts[id] = true;
        } else {
            this.serverboundInts[id] = true;
        }
    }

    public void rewriteServerbound(ByteBuf packet, int oldId, int newId) {
        EntityMap.rewrite(packet, oldId, newId, this.serverboundInts, this.serverboundVarInts);
    }

    public void rewriteServerbound(ByteBuf packet, int oldId, int newId, int protocolVersion) {
        this.rewriteServerbound(packet, oldId, newId);
    }

    public void rewriteClientbound(ByteBuf packet, int oldId, int newId) {
        EntityMap.rewrite(packet, oldId, newId, this.clientboundInts, this.clientboundVarInts);
    }

    public void rewriteClientbound(ByteBuf packet, int oldId, int newId, int protocolVersion) {
        this.rewriteClientbound(packet, oldId, newId);
    }

    protected static void rewriteInt(ByteBuf packet, int oldId, int newId, int offset) {
        int readId = packet.getInt(offset);
        if (readId == oldId) {
            packet.setInt(offset, newId);
        } else if (readId == newId) {
            packet.setInt(offset, oldId);
        }
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    protected static void rewriteVarInt(ByteBuf packet, int oldId, int newId, int offset) {
        int readId = DefinedPacket.readVarInt(packet);
        int readIdLength = packet.readerIndex() - offset;
        if (readId == oldId || readId == newId) {
            ByteBuf data = packet.copy();
            packet.readerIndex(offset);
            packet.writerIndex(offset);
            DefinedPacket.writeVarInt(readId == oldId ? newId : oldId, packet);
            packet.writeBytes(data);
            data.release();
        }
    }

    protected static void rewriteMetaVarInt(ByteBuf packet, int oldId, int newId, int metaIndex) {
        EntityMap.rewriteMetaVarInt(packet, oldId, newId, metaIndex, -1);
    }

    protected static void rewriteMetaVarInt(ByteBuf packet, int oldId, int newId, int metaIndex, int protocolVersion) {
        short index;
        int readerIndex = packet.readerIndex();
        block32: while ((index = packet.readUnsignedByte()) != 255) {
            int type = DefinedPacket.readVarInt(packet);
            if (protocolVersion >= 393) {
                switch (type) {
                    case 5: {
                        if (!packet.readBoolean()) continue block32;
                        DefinedPacket.readString(packet);
                        continue block32;
                    }
                    case 15: {
                        int particleId = DefinedPacket.readVarInt(packet);
                        if (protocolVersion >= 477) {
                            switch (particleId) {
                                case 3: 
                                case 23: {
                                    DefinedPacket.readVarInt(packet);
                                    break;
                                }
                                case 14: {
                                    packet.skipBytes(16);
                                    break;
                                }
                                case 32: {
                                    EntityMap.readSkipSlot(packet, protocolVersion);
                                }
                            }
                            continue block32;
                        }
                        switch (particleId) {
                            case 3: 
                            case 20: {
                                DefinedPacket.readVarInt(packet);
                                break;
                            }
                            case 11: {
                                packet.skipBytes(16);
                                break;
                            }
                            case 27: {
                                EntityMap.readSkipSlot(packet, protocolVersion);
                            }
                        }
                        continue block32;
                    }
                }
                if (type >= 6) {
                    --type;
                }
            }
            switch (type) {
                case 0: {
                    packet.skipBytes(1);
                    continue block32;
                }
                case 1: {
                    if (index == metaIndex) {
                        int position = packet.readerIndex();
                        EntityMap.rewriteVarInt(packet, oldId, newId, position);
                        packet.readerIndex(position);
                    }
                    DefinedPacket.readVarInt(packet);
                    continue block32;
                }
                case 2: {
                    packet.skipBytes(4);
                    continue block32;
                }
                case 3: 
                case 4: {
                    DefinedPacket.readString(packet);
                    continue block32;
                }
                case 5: {
                    EntityMap.readSkipSlot(packet, protocolVersion);
                    continue block32;
                }
                case 6: {
                    packet.skipBytes(1);
                    continue block32;
                }
                case 7: {
                    packet.skipBytes(12);
                    continue block32;
                }
                case 8: {
                    packet.readLong();
                    continue block32;
                }
                case 9: {
                    if (!packet.readBoolean()) continue block32;
                    packet.skipBytes(8);
                    continue block32;
                }
                case 10: {
                    DefinedPacket.readVarInt(packet);
                    continue block32;
                }
                case 11: {
                    if (!packet.readBoolean()) continue block32;
                    packet.skipBytes(16);
                    continue block32;
                }
                case 12: {
                    DefinedPacket.readVarInt(packet);
                    continue block32;
                }
                case 13: {
                    Tag tag = NamedTag.read(new DataInputStream(new ByteBufInputStream(packet)));
                    if (!tag.isError()) continue block32;
                    throw new RuntimeException(tag.error());
                }
                case 15: {
                    DefinedPacket.readVarInt(packet);
                    DefinedPacket.readVarInt(packet);
                    DefinedPacket.readVarInt(packet);
                    continue block32;
                }
                case 16: {
                    if (index == metaIndex) {
                        int position = packet.readerIndex();
                        EntityMap.rewriteVarInt(packet, oldId + 1, newId + 1, position);
                        packet.readerIndex(position);
                    }
                    DefinedPacket.readVarInt(packet);
                    continue block32;
                }
                case 17: {
                    DefinedPacket.readVarInt(packet);
                    continue block32;
                }
            }
            if (protocolVersion >= 393) {
                ++type;
            }
            throw new IllegalArgumentException("Unknown meta type " + type + ": Using mods? refer to disable_entity_metadata_rewrite in waterfall.yml");
        }
        packet.readerIndex(readerIndex);
    }

    private static void readSkipSlot(ByteBuf packet, int protocolVersion) {
        if (protocolVersion >= 404 ? packet.readBoolean() : packet.readShort() != -1) {
            if (protocolVersion >= 404) {
                DefinedPacket.readVarInt(packet);
            }
            packet.skipBytes(protocolVersion >= 393 ? 1 : 3);
            int position = packet.readerIndex();
            if (packet.readByte() != 0) {
                packet.readerIndex(position);
                Tag tag = NamedTag.read(new DataInputStream(new ByteBufInputStream(packet)));
                if (tag.isError()) {
                    throw new RuntimeException(tag.error());
                }
            }
        }
    }

    private static void rewrite(ByteBuf packet, int oldId, int newId, boolean[] ints, boolean[] varints) {
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        if (packetId < 0 || packetId > ints.length || packetId > varints.length) {
            packet.readerIndex(readerIndex);
            return;
        }
        if (ints[packetId]) {
            EntityMap.rewriteInt(packet, oldId, newId, readerIndex + packetIdLength);
        } else if (varints[packetId]) {
            EntityMap.rewriteVarInt(packet, oldId, newId, readerIndex + packetIdLength);
        }
        packet.readerIndex(readerIndex);
    }

    EntityMap() {
    }
}

