/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.charset.Charset;
import net.md_5.bungee.api.Callback;

public class HttpHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private final Callback<String> callback;
    private final StringBuilder buffer = new StringBuilder(640);

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try {
            this.callback.done(null, cause);
        }
        finally {
            ctx.channel().close();
        }
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            int responseCode = response.status().code();
            if (responseCode == HttpResponseStatus.NO_CONTENT.code()) {
                this.done(ctx);
                return;
            }
            if (responseCode != HttpResponseStatus.OK.code()) {
                throw new IllegalStateException("Expected HTTP response 200 OK, got " + response.status());
            }
        }
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            this.buffer.append(content.content().toString(Charset.forName("UTF-8")));
            if (msg instanceof LastHttpContent) {
                this.done(ctx);
            }
        }
    }

    private void done(ChannelHandlerContext ctx) {
        try {
            this.callback.done(this.buffer.toString(), null);
        }
        finally {
            ctx.channel().close();
        }
    }

    public HttpHandler(Callback<String> callback) {
        this.callback = callback;
    }
}

