/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import io.github.waterfallmc.waterfall.event.ProxyDefineCommandsEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.unix.DomainSocketAddress;
import java.io.DataInput;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.ServerConnector;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.event.ServerDisconnectEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.event.TabCompleteResponseEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.score.Objective;
import net.md_5.bungee.api.score.Position;
import net.md_5.bungee.api.score.Score;
import net.md_5.bungee.api.score.Scoreboard;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.entitymap.EntityMap;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.BossBar;
import net.md_5.bungee.protocol.packet.Commands;
import net.md_5.bungee.protocol.packet.EntityEffect;
import net.md_5.bungee.protocol.packet.EntityRemoveEffect;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PlayerListItemRemove;
import net.md_5.bungee.protocol.packet.PlayerListItemUpdate;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.ScoreboardScoreReset;
import net.md_5.bungee.protocol.packet.ServerData;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;
import net.md_5.bungee.protocol.packet.Team;
import net.md_5.bungee.tab.TabList;

public class DownstreamBridge
extends PacketHandler {
    private static final com.mojang.brigadier.Command DUMMY_COMMAND = context -> 0;
    private final ProxyServer bungee;
    private final UserConnection con;
    private final ServerConnection server;
    private boolean receivedLogin;

    @Override
    public void exception(Throwable t2) throws Exception {
        if (this.server.isObsolete()) {
            return;
        }
        ServerInfo def = this.con.updateAndGetNextServer(this.server.getInfo());
        ServerKickEvent event = this.bungee.getPluginManager().callEvent(new ServerKickEvent((ProxiedPlayer)this.con, (ServerInfo)this.server.getInfo(), TextComponent.fromLegacyText(this.bungee.getTranslation("server_went_down", new Object[0])), def, ServerKickEvent.State.CONNECTED, ServerKickEvent.Cause.EXCEPTION));
        if (event.isCancelled() && event.getCancelServer() != null) {
            this.server.setObsolete(true);
            this.con.connectNow(event.getCancelServer(), ServerConnectEvent.Reason.SERVER_DOWN_REDIRECT);
        } else {
            this.con.disconnect0(event.getReason());
        }
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        this.server.getInfo().removePlayer(this.con);
        if (this.bungee.getReconnectHandler() != null) {
            this.bungee.getReconnectHandler().setServer(this.con);
        }
        if (!this.server.isObsolete()) {
            ServerInfo def = this.con.updateAndGetNextServer(this.server.getInfo());
            ServerKickEvent event = this.bungee.getPluginManager().callEvent(new ServerKickEvent((ProxiedPlayer)this.con, (ServerInfo)this.server.getInfo(), TextComponent.fromLegacyText(this.bungee.getTranslation("lost_connection", new Object[0])), def, ServerKickEvent.State.CONNECTED, ServerKickEvent.Cause.LOST_CONNECTION));
            if (event.isCancelled() && event.getCancelServer() != null) {
                this.server.setObsolete(true);
                this.con.connectNow(event.getCancelServer());
            } else {
                this.con.disconnect0(event.getReason());
            }
        }
        ServerDisconnectEvent serverDisconnectEvent = new ServerDisconnectEvent(this.con, this.server.getInfo());
        this.bungee.getPluginManager().callEvent(serverDisconnectEvent);
    }

    @Override
    public boolean shouldHandle(PacketWrapper packet) throws Exception {
        return !this.server.isObsolete();
    }

    @Override
    public void handle(PacketWrapper packet) throws Exception {
        EntityMap rewrite = this.con.getEntityRewrite();
        if (rewrite != null && this.con.getCh().getEncodeProtocol() == Protocol.GAME) {
            rewrite.rewriteClientbound(packet.buf, this.con.getServerEntityId(), this.con.getClientEntityId(), this.con.getPendingConnection().getVersion());
        }
        this.con.sendPacket(packet);
    }

    @Override
    public void handle(KeepAlive alive) throws Exception {
        int timeout = this.bungee.getConfig().getTimeout();
        if (timeout <= 0 || this.server.getKeepAlives().size() < timeout / 50) {
            this.server.getKeepAlives().add(new ServerConnection.KeepAliveData(alive.getRandomId(), System.currentTimeMillis()));
        }
    }

    @Override
    public void handle(PlayerListItem playerList) throws Exception {
        boolean skipRewrites = this.bungee.getConfig().isDisableTabListRewrite();
        this.con.getTabListHandler().onUpdate(skipRewrites ? playerList : TabList.rewrite(playerList));
        if (!skipRewrites) {
            throw CancelSendSignal.INSTANCE;
        }
    }

    @Override
    public void handle(PlayerListItemRemove playerList) throws Exception {
        this.con.getTabListHandler().onUpdate(TabList.rewrite(playerList));
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(PlayerListItemUpdate playerList) throws Exception {
        this.con.getTabListHandler().onUpdate(TabList.rewrite(playerList));
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(ScoreboardObjective objective) throws Exception {
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        switch (objective.getAction()) {
            case 0: {
                serverScoreboard.addObjective(new Objective(objective.getName(), objective.getValue().isLeft() ? objective.getValue().getLeft() : ComponentSerializer.toString(objective.getValue().getRight()), objective.getType().toString()));
                break;
            }
            case 1: {
                serverScoreboard.removeObjective(objective.getName());
                break;
            }
            case 2: {
                Objective oldObjective = serverScoreboard.getObjective(objective.getName());
                if (oldObjective == null) break;
                oldObjective.setValue(objective.getValue().isLeft() ? objective.getValue().getLeft() : ComponentSerializer.toString(objective.getValue().getRight()));
                oldObjective.setType(objective.getType().toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown objective action: " + objective.getAction());
            }
        }
    }

    @Override
    public void handle(ScoreboardScore score) throws Exception {
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        switch (score.getAction()) {
            case 0: {
                Score s2 = new Score(score.getItemName(), score.getScoreName(), score.getValue());
                serverScoreboard.removeScore(score.getItemName());
                serverScoreboard.addScore(s2);
                break;
            }
            case 1: {
                serverScoreboard.removeScore(score.getItemName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown scoreboard action: " + score.getAction());
            }
        }
    }

    @Override
    public void handle(ScoreboardScoreReset scoreboardScoreReset) throws Exception {
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        if (scoreboardScoreReset.getScoreName() == null) {
            serverScoreboard.removeScore(scoreboardScoreReset.getItemName());
        }
    }

    @Override
    public void handle(ScoreboardDisplay displayScoreboard) throws Exception {
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        serverScoreboard.setName(displayScoreboard.getName());
        serverScoreboard.setPosition(Position.values()[displayScoreboard.getPosition()]);
    }

    @Override
    public void handle(Team team) throws Exception {
        net.md_5.bungee.api.score.Team t2;
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        if (team.getMode() == 1) {
            serverScoreboard.removeTeam(team.getName());
            return;
        }
        if (team.getMode() == 0) {
            t2 = new net.md_5.bungee.api.score.Team(team.getName());
            serverScoreboard.addTeam(t2);
        } else {
            t2 = serverScoreboard.getTeam(team.getName());
        }
        if (t2 != null) {
            if (team.getMode() == 0 || team.getMode() == 2) {
                t2.setDisplayName(team.getDisplayName().getLeftOrCompute(ComponentSerializer::toString));
                t2.setPrefix(team.getPrefix().getLeftOrCompute(ComponentSerializer::toString));
                t2.setSuffix(team.getSuffix().getLeftOrCompute(ComponentSerializer::toString));
                t2.setFriendlyFire(team.getFriendlyFire());
                t2.setNameTagVisibility(team.getNameTagVisibility());
                t2.setCollisionRule(team.getCollisionRule());
                t2.setColor(team.getColor());
            }
            if (team.getPlayers() != null) {
                for (String s2 : team.getPlayers()) {
                    if (team.getMode() == 0 || team.getMode() == 3) {
                        t2.addPlayer(s2);
                        continue;
                    }
                    if (team.getMode() != 4) continue;
                    t2.removePlayer(s2);
                }
            }
        }
    }

    @Override
    public void handle(PluginMessage pluginMessage) throws Exception {
        PluginMessageEvent event = new PluginMessageEvent(this.server, this.con, pluginMessage.getTag(), (byte[])pluginMessage.getData().clone());
        if (this.bungee.getPluginManager().callEvent(event).isCancelled()) {
            throw CancelSendSignal.INSTANCE;
        }
        if (pluginMessage.getTag().equals(this.con.getPendingConnection().getVersion() >= 393 ? "minecraft:brand" : "MC|Brand")) {
            ByteBuf brand = Unpooled.wrappedBuffer(pluginMessage.getData());
            String serverBrand = DefinedPacket.readString(brand);
            brand.release();
            Preconditions.checkState(!serverBrand.contains(this.bungee.getName()), "Cannot connect proxy to itself!");
            brand = ByteBufAllocator.DEFAULT.heapBuffer();
            DefinedPacket.writeString(this.bungee.getName() + " <- " + serverBrand, brand);
            pluginMessage.setData(brand);
            brand.release();
            this.con.unsafe().sendPacket(pluginMessage);
            throw CancelSendSignal.INSTANCE;
        }
        if (pluginMessage.getTag().equals("BungeeCord")) {
            byte[] b;
            String subChannel;
            DataInput in = pluginMessage.getStream();
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            block20 : switch (subChannel = in.readUTF()) {
                case "ForwardToPlayer": {
                    ProxiedPlayer target = this.bungee.getPlayer(in.readUTF());
                    if (target != null) {
                        String channel = in.readUTF();
                        short len = in.readShort();
                        byte[] data = new byte[len];
                        in.readFully(data);
                        out.writeUTF(channel);
                        out.writeShort(data.length);
                        out.write(data);
                        byte[] payload = out.toByteArray();
                        target.getServer().sendData("BungeeCord", payload);
                    }
                    out = null;
                    break;
                }
                case "Forward": {
                    String target = in.readUTF();
                    String channel = in.readUTF();
                    short len = in.readShort();
                    byte[] data = new byte[len];
                    in.readFully(data);
                    out.writeUTF(channel);
                    out.writeShort(data.length);
                    out.write(data);
                    byte[] payload = out.toByteArray();
                    out = null;
                    switch (target) {
                        case "ALL": {
                            for (ServerInfo server : this.bungee.getServers().values()) {
                                if (server == this.server.getInfo()) continue;
                                server.sendData("BungeeCord", payload);
                            }
                            break block20;
                        }
                        case "ONLINE": {
                            for (ServerInfo server : this.bungee.getServers().values()) {
                                if (server == this.server.getInfo()) continue;
                                server.sendData("BungeeCord", payload, false);
                            }
                            break block20;
                        }
                        default: {
                            ServerInfo server = this.bungee.getServerInfo(target);
                            if (server == null) break block20;
                            server.sendData("BungeeCord", payload);
                            break;
                        }
                    }
                    break;
                }
                case "Connect": {
                    ServerInfo server = this.bungee.getServerInfo(in.readUTF());
                    if (server == null) break;
                    this.con.connect(server, ServerConnectEvent.Reason.PLUGIN_MESSAGE);
                    break;
                }
                case "ConnectOther": {
                    ServerInfo server;
                    ProxiedPlayer player = this.bungee.getPlayer(in.readUTF());
                    if (player == null || (server = this.bungee.getServerInfo(in.readUTF())) == null) break;
                    player.connect(server);
                    break;
                }
                case "GetPlayerServer": {
                    String name = in.readUTF();
                    ProxiedPlayer player = this.bungee.getPlayer(name);
                    out.writeUTF("GetPlayerServer");
                    out.writeUTF(name);
                    if (player == null) {
                        out.writeUTF("");
                        break;
                    }
                    Server srv = player.getServer();
                    if (srv == null) {
                        out.writeUTF("");
                        break;
                    }
                    out.writeUTF(srv.getInfo().getName());
                    break;
                }
                case "IP": {
                    out.writeUTF("IP");
                    if (this.con.getSocketAddress() instanceof InetSocketAddress) {
                        out.writeUTF(this.con.getAddress().getHostString());
                        out.writeInt(this.con.getAddress().getPort());
                        break;
                    }
                    out.writeUTF("unix://" + ((DomainSocketAddress)this.con.getSocketAddress()).path());
                    out.writeInt(0);
                    break;
                }
                case "IPOther": {
                    ProxiedPlayer player = this.bungee.getPlayer(in.readUTF());
                    if (player == null) break;
                    out.writeUTF("IPOther");
                    out.writeUTF(player.getName());
                    if (player.getSocketAddress() instanceof InetSocketAddress) {
                        InetSocketAddress address = (InetSocketAddress)player.getSocketAddress();
                        out.writeUTF(address.getHostString());
                        out.writeInt(address.getPort());
                        break;
                    }
                    out.writeUTF("unix://" + ((DomainSocketAddress)player.getSocketAddress()).path());
                    out.writeInt(0);
                    break;
                }
                case "PlayerCount": {
                    String target = in.readUTF();
                    out.writeUTF("PlayerCount");
                    if (target.equals("ALL")) {
                        out.writeUTF("ALL");
                        out.writeInt(this.bungee.getOnlineCount());
                        break;
                    }
                    ServerInfo server = this.bungee.getServerInfo(target);
                    if (server == null) break;
                    out.writeUTF(server.getName());
                    out.writeInt(server.getPlayers().size());
                    break;
                }
                case "PlayerList": {
                    String target = in.readUTF();
                    out.writeUTF("PlayerList");
                    if (target.equals("ALL")) {
                        out.writeUTF("ALL");
                        out.writeUTF(Util.csv(this.bungee.getPlayers()));
                        break;
                    }
                    ServerInfo server = this.bungee.getServerInfo(target);
                    if (server == null) break;
                    out.writeUTF(server.getName());
                    out.writeUTF(Util.csv(server.getPlayers()));
                    break;
                }
                case "GetServers": {
                    out.writeUTF("GetServers");
                    out.writeUTF(Util.csv(this.bungee.getServers().keySet()));
                    break;
                }
                case "Message": {
                    String target = in.readUTF();
                    String message = in.readUTF();
                    if (target.equals("ALL")) {
                        for (ProxiedPlayer player : this.bungee.getPlayers()) {
                            player.sendMessage(message);
                        }
                        break;
                    }
                    ProxiedPlayer player = this.bungee.getPlayer(target);
                    if (player == null) break;
                    player.sendMessage(message);
                    break;
                }
                case "MessageRaw": {
                    String target = in.readUTF();
                    BaseComponent[] message = ComponentSerializer.parse(in.readUTF());
                    if (target.equals("ALL")) {
                        for (ProxiedPlayer player : this.bungee.getPlayers()) {
                            player.sendMessage(message);
                        }
                        break;
                    }
                    ProxiedPlayer player = this.bungee.getPlayer(target);
                    if (player == null) break;
                    player.sendMessage(message);
                    break;
                }
                case "GetServer": {
                    out.writeUTF("GetServer");
                    out.writeUTF(this.server.getInfo().getName());
                    break;
                }
                case "UUID": {
                    out.writeUTF("UUID");
                    out.writeUTF(this.con.getUUID());
                    break;
                }
                case "UUIDOther": {
                    ProxiedPlayer player = this.bungee.getPlayer(in.readUTF());
                    if (player == null) break;
                    out.writeUTF("UUIDOther");
                    out.writeUTF(player.getName());
                    out.writeUTF(player.getUUID());
                    break;
                }
                case "ServerIP": {
                    ServerInfo info = this.bungee.getServerInfo(in.readUTF());
                    if (info == null || info.getAddress().isUnresolved()) break;
                    out.writeUTF("ServerIP");
                    out.writeUTF(info.getName());
                    out.writeUTF(info.getAddress().getAddress().getHostAddress());
                    out.writeShort(info.getAddress().getPort());
                    break;
                }
                case "KickPlayer": {
                    ProxiedPlayer player = this.bungee.getPlayer(in.readUTF());
                    if (player == null) break;
                    String kickReason = in.readUTF();
                    player.disconnect((BaseComponent)new TextComponent(kickReason));
                    break;
                }
                case "KickPlayerRaw": {
                    ProxiedPlayer player = this.bungee.getPlayer(in.readUTF());
                    if (player == null) break;
                    BaseComponent[] kickReason = ComponentSerializer.parse(in.readUTF());
                    player.disconnect(kickReason);
                    break;
                }
            }
            if (out != null && (b = out.toByteArray()).length != 0) {
                this.server.sendData("BungeeCord", b);
            }
            throw CancelSendSignal.INSTANCE;
        }
    }

    @Override
    public void handle(Kick kick) throws Exception {
        ServerKickEvent event;
        ServerInfo def = this.con.updateAndGetNextServer(this.server.getInfo());
        if (Objects.equals(this.server.getInfo(), def)) {
            def = null;
        }
        if ((event = this.bungee.getPluginManager().callEvent(new ServerKickEvent((ProxiedPlayer)this.con, (ServerInfo)this.server.getInfo(), new BaseComponent[]{kick.getMessage()}, def, ServerKickEvent.State.CONNECTED, ServerKickEvent.Cause.SERVER))).isCancelled() && event.getCancelServer() != null) {
            this.con.connectNow(event.getCancelServer(), ServerConnectEvent.Reason.KICK_REDIRECT);
        } else {
            this.con.disconnect(event.getKickReasonComponent());
        }
        this.server.setObsolete(true);
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(SetCompression setCompression) throws Exception {
        this.server.getCh().setCompressionThreshold(setCompression.getThreshold());
    }

    @Override
    public void handle(TabCompleteResponse tabCompleteResponse) throws Exception {
        List<String> commands = tabCompleteResponse.getCommands();
        if (commands == null) {
            commands = Lists.transform(tabCompleteResponse.getSuggestions().getList(), new Function<Suggestion, String>(){

                @Override
                public String apply(Suggestion input) {
                    return input.getText();
                }
            });
        } else {
            String last = this.con.getLastCommandTabbed();
            if (last != null) {
                String commandName = last.toLowerCase(Locale.ROOT);
                commands.addAll(this.bungee.getPluginManager().getCommands().stream().filter(entry -> {
                    String lowerCase = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
                    return lowerCase.startsWith(commandName) && ((Command)entry.getValue()).hasPermission(this.con) && !this.bungee.getDisabledCommands().contains(lowerCase);
                }).map(stringCommandEntry -> '/' + (String)stringCommandEntry.getKey()).collect(Collectors.toList()));
                commands.sort(null);
                this.con.setLastCommandTabbed(null);
            }
        }
        TabCompleteResponseEvent tabCompleteResponseEvent = new TabCompleteResponseEvent(this.server, this.con, new ArrayList<String>(commands));
        if (!this.bungee.getPluginManager().callEvent(tabCompleteResponseEvent).isCancelled()) {
            if (!commands.equals(tabCompleteResponseEvent.getSuggestions())) {
                if (tabCompleteResponse.getCommands() != null) {
                    tabCompleteResponse.setCommands(tabCompleteResponseEvent.getSuggestions());
                } else {
                    final StringRange range = tabCompleteResponse.getSuggestions().getRange();
                    tabCompleteResponse.setSuggestions(new Suggestions(range, Lists.transform(tabCompleteResponseEvent.getSuggestions(), new Function<String, Suggestion>(){

                        @Override
                        public Suggestion apply(String input) {
                            return new Suggestion(range, input);
                        }
                    })));
                }
            }
            this.con.unsafe().sendPacket(tabCompleteResponse);
        }
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(BossBar bossBar) {
        switch (bossBar.getAction()) {
            case 0: {
                this.con.getSentBossBars().add(bossBar.getUuid());
                break;
            }
            case 1: {
                this.con.getSentBossBars().remove(bossBar.getUuid());
            }
        }
    }

    @Override
    public void handle(EntityEffect entityEffect) throws Exception {
        if (this.con.isDisableEntityMetadataRewrite()) {
            return;
        }
        if (this.con.getForgeClientHandler().isForgeUser() && !this.con.getForgeClientHandler().isHandshakeComplete()) {
            throw CancelSendSignal.INSTANCE;
        }
        this.con.getPotions().put(this.rewriteEntityId(entityEffect.getEntityId()), entityEffect.getEffectId());
    }

    @Override
    public void handle(EntityRemoveEffect removeEffect) throws Exception {
        if (this.con.isDisableEntityMetadataRewrite()) {
            return;
        }
        this.con.getPotions().remove(this.rewriteEntityId(removeEffect.getEntityId()), removeEffect.getEffectId());
    }

    private int rewriteEntityId(int entityId) {
        if (entityId == this.con.getServerEntityId()) {
            return this.con.getClientEntityId();
        }
        return entityId;
    }

    @Override
    public void handle(Respawn respawn) {
        this.con.setDimension(respawn.getDimension());
    }

    @Override
    public void handle(Commands commands) throws Exception {
        boolean modified = false;
        HashMap<String, Command> commandMap = new HashMap<String, Command>();
        for (Map.Entry<String, Command> commandEntry : this.bungee.getPluginManager().getCommands()) {
            if (this.bungee.getDisabledCommands().contains(commandEntry.getKey()) || commands.getRoot().getChild(commandEntry.getKey()) != null || !commandEntry.getValue().hasPermission(this.con)) continue;
            commandMap.put(commandEntry.getKey(), commandEntry.getValue());
        }
        ProxyDefineCommandsEvent event = new ProxyDefineCommandsEvent(this.server, this.con, commandMap);
        this.bungee.getPluginManager().callEvent(event);
        for (Map.Entry<String, Command> command : event.getCommands().entrySet()) {
            CommandNode dummy = ((ArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal(command.getKey()).executes(DUMMY_COMMAND)).then(RequiredArgumentBuilder.argument("args", StringArgumentType.greedyString()).suggests(Commands.SuggestionRegistry.ASK_SERVER).executes(DUMMY_COMMAND))).build();
            commands.getRoot().addChild(dummy);
            modified = true;
        }
        if (modified) {
            this.con.unsafe().sendPacket(commands);
            throw CancelSendSignal.INSTANCE;
        }
    }

    @Override
    public void handle(ServerData serverData) throws Exception {
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(Login login) throws Exception {
        Preconditions.checkState(!this.receivedLogin, "Not expecting login");
        this.receivedLogin = true;
        ServerConnector.handleLogin(this.bungee, this.server.getCh(), this.con, this.server.getInfo(), null, this.server, login);
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public String toString() {
        return "[" + this.con.getAddress() + "|" + this.con.getName() + "] <-> DownstreamBridge <-> [" + this.server.getInfo().getName() + "]";
    }

    public DownstreamBridge(ProxyServer bungee, UserConnection con, ServerConnection server) {
        this.bungee = bungee;
        this.con = con;
        this.server = server;
    }
}

