/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.forge;

import java.util.ArrayDeque;
import lombok.Generated;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.forge.ForgeLogger;
import net.md_5.bungee.forge.ForgeServerHandshakeState;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.protocol.packet.PluginMessage;

public class ForgeServerHandler {
    private final UserConnection con;
    private final ChannelWrapper ch;
    private final ServerInfo serverInfo;
    private ForgeServerHandshakeState state = ForgeServerHandshakeState.START;
    private boolean serverForge = false;
    private final ArrayDeque<PluginMessage> packetQueue = new ArrayDeque();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(PluginMessage message) throws IllegalArgumentException {
        if (!message.getTag().equalsIgnoreCase("FML|HS") && !message.getTag().equalsIgnoreCase("FORGE")) {
            throw new IllegalArgumentException("Expecting a Forge REGISTER or FML Handshake packet.");
        }
        message.setAllowExtendedPacket(true);
        ForgeServerHandshakeState prevState = this.state;
        this.packetQueue.add(message);
        this.state = (ForgeServerHandshakeState)this.state.send(message, this.con);
        if (this.state == ForgeServerHandshakeState.DONE || this.state != prevState) {
            ArrayDeque<PluginMessage> arrayDeque = this.packetQueue;
            synchronized (arrayDeque) {
                while (!this.packetQueue.isEmpty()) {
                    ForgeLogger.logServer(ForgeLogger.LogDirection.SENDING, prevState.name(), this.packetQueue.getFirst());
                    this.con.getForgeClientHandler().receive(this.packetQueue.removeFirst());
                }
            }
        }
    }

    public void receive(PluginMessage message) throws IllegalArgumentException {
        this.state = (ForgeServerHandshakeState)this.state.handle(message, this.ch);
    }

    public void setServerAsForgeServer() {
        this.serverForge = true;
    }

    @Generated
    public ForgeServerHandler(UserConnection con, ChannelWrapper ch, ServerInfo serverInfo) {
        this.con = con;
        this.ch = ch;
        this.serverInfo = serverInfo;
    }

    @Generated
    public ChannelWrapper getCh() {
        return this.ch;
    }

    @Generated
    ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    @Generated
    public ForgeServerHandshakeState getState() {
        return this.state;
    }

    @Generated
    public boolean isServerForge() {
        return this.serverForge;
    }
}

